/* Demo Application for PCANBasic JAVA JNI Interface
 * @version 1.10
 * @LastChange 09/04/2013
 * @author Jonathan Urban/Uwe Wilhelm/Fabrice Vergnaud
 *
 * @Copyright (C) 1999-2014  PEAK-System Technik GmbH, Darmstadt
 * more Info at http://www.peak-system.com
*/

package peak.can;

import java.awt.Component;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import peak.can.basic.TPCANBaudrate;
import peak.can.basic.PCANBasic;
import peak.can.basic.RcvEventDispatcher;
import peak.can.basic.TPCANBitrateFD;
import peak.can.basic.TPCANHandle;
import peak.can.basic.TPCANMessageType;
import peak.can.basic.TPCANMode;
import peak.can.basic.TPCANMsg;
import peak.can.basic.TPCANMsgFD;
import peak.can.basic.TPCANParameter;
import peak.can.basic.TPCANParameterValue;
import peak.can.basic.TPCANStatus;
import peak.can.basic.TPCANType;

public class Application extends javax.swing.JFrame
{
    int MAX_PATH = 256; // not Soooo... OS independend
    public Application()
    {
        // Initialization
        initComponents();
        
        // Crate New instance of PCANBasic
        pcanBasic = new PCANBasic();
        // JNI Initialization
        pcanBasic.initializeAPI();
        int interval=100;

        // Init TimeStamp Grid Column
        columnTimeStamp = new TableColumn();
        columnTimeStamp.setMinWidth(100);
        columnTimeStamp.setMaxWidth(100);
        columnTimeStamp.setWidth(100);
        columnTimeStamp.setResizable(false);
        columnTimeStamp.setHeaderValue("Rcv Time");
        columnTimeStamp.setModelIndex(5);
        jTableMessage.getColumnModel().removeColumn(jTableMessage.getColumnModel().getColumn(jTableMessage.getColumnModel().getColumnCount() - 1));

        // Create Collection for connected Channels
        connectedChannelCollection = new Vector<ChannelItem>();
        jComboBoxConnectedChannel.setModel(new DefaultComboBoxModel(connectedChannelCollection));

        // Create and start ReadMessage Thread
        canReadThread = new CANReadThread(pcanBasic, connectedChannelCollection, receivedData);
        canReadThread.start();
             
        // Create and start Table Message Thread
        tableMessageThread = new TableMessageThread(jTableMessage, receivedData);
        tableMessageThread.start();
        this.setTitle("I CAN Do It! - Basic - " +  System.getProperty( "sun.arch.data.model") + " Bit");
        jLabel15.setText(jLabel15.getText() + " - using a " + System.getProperty( "sun.arch.data.model") + " Bit Runtime - JAVA Version: " + System.getProperty("java.version"));
        
        // UI Update
        UpdateUIButtons();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        buttonGroupReadMode = new javax.swing.ButtonGroup();
        buttonGroupONOFF = new javax.swing.ButtonGroup();
        buttonGroupOpenClose = new javax.swing.ButtonGroup();
        buttonGroupFilter = new javax.swing.ButtonGroup();
        jPanelHardware = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jComboBoxChannel = new javax.swing.JComboBox();
        jComboBoxBaudrate = new javax.swing.JComboBox();
        jLabel3 = new javax.swing.JLabel();
        jComboBoxPort = new javax.swing.JComboBox();
        jLabel4 = new javax.swing.JLabel();
        jComboBoxInterrupt = new javax.swing.JComboBox();
        jLabel5 = new javax.swing.JLabel();
        jComboBoxHardwareType = new javax.swing.JComboBox();
        jButtonConnect = new javax.swing.JButton();
        jCheckBoxCanFd = new javax.swing.JCheckBox();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTextAreaBitRateFd = new javax.swing.JTextArea();
        jPanelNewConnection = new javax.swing.JPanel();
        jLabel61 = new javax.swing.JLabel();
        jComboBoxConnectedChannel = new javax.swing.JComboBox();
        jButtonRelease = new javax.swing.JButton();
        jLabel62 = new javax.swing.JLabel();
        jButtonPause = new javax.swing.JButton();
        jButtonStart = new javax.swing.JButton();
        jPanelInfo = new javax.swing.JPanel();
        jScrollPaneInfo = new javax.swing.JScrollPane();
        jTexteAreaInfo = new javax.swing.JTextArea();
        jPanelRead = new javax.swing.JPanel();
        jScrollPane2 = new javax.swing.JScrollPane();
        jTableMessage = new javax.swing.JTable();
        jCheckBoxTimeStamp = new javax.swing.JCheckBox();
        jLabel10 = new javax.swing.JLabel();
        jRadioButtonTimer = new javax.swing.JRadioButton();
        jRadioButtonEvent = new javax.swing.JRadioButton();
        jButtonReadClear = new javax.swing.JButton();
        jPanelWrite = new javax.swing.JPanel();
        jTextFieldWriteID = new javax.swing.JTextField();
        jLabel7 = new javax.swing.JLabel();
        jSpinnerLength = new javax.swing.JSpinner();
        jLabel8 = new javax.swing.JLabel();
        jButtonWrite = new javax.swing.JButton();
        jCheckBoxWriteExtended = new javax.swing.JCheckBox();
        jCheckBoxWriteRemote = new javax.swing.JCheckBox();
        jTextFieldSendTiming = new javax.swing.JTextField();
        jLabel12 = new javax.swing.JLabel();
        jCheckBoxSendingThread = new javax.swing.JCheckBox();
        jLabel21 = new javax.swing.JLabel();
        jTextFieldWriteID1 = new javax.swing.JTextField();
        jCheckBoxWriteFd = new javax.swing.JCheckBox();
        jCheckBoxWriteBrs = new javax.swing.JCheckBox();
        jPanelWriteData = new javax.swing.JPanel();
        jTextFieldData0 = new javax.swing.JTextField();
        jTextFieldData1 = new javax.swing.JTextField();
        jTextFieldData2 = new javax.swing.JTextField();
        jTextFieldData3 = new javax.swing.JTextField();
        jTextFieldData4 = new javax.swing.JTextField();
        jTextFieldData5 = new javax.swing.JTextField();
        jTextFieldData6 = new javax.swing.JTextField();
        jTextFieldData7 = new javax.swing.JTextField();
        jTextFieldData8 = new javax.swing.JTextField();
        jTextFieldData9 = new javax.swing.JTextField();
        jTextFieldData10 = new javax.swing.JTextField();
        jTextFieldData11 = new javax.swing.JTextField();
        jTextFieldData12 = new javax.swing.JTextField();
        jTextFieldData13 = new javax.swing.JTextField();
        jTextFieldData14 = new javax.swing.JTextField();
        jTextFieldData15 = new javax.swing.JTextField();
        jTextFieldData16 = new javax.swing.JTextField();
        jTextFieldData17 = new javax.swing.JTextField();
        jTextFieldData18 = new javax.swing.JTextField();
        jTextFieldData19 = new javax.swing.JTextField();
        jTextFieldData20 = new javax.swing.JTextField();
        jTextFieldData21 = new javax.swing.JTextField();
        jTextFieldData22 = new javax.swing.JTextField();
        jTextFieldData23 = new javax.swing.JTextField();
        jTextFieldData24 = new javax.swing.JTextField();
        jTextFieldData25 = new javax.swing.JTextField();
        jTextFieldData26 = new javax.swing.JTextField();
        jTextFieldData27 = new javax.swing.JTextField();
        jTextFieldData28 = new javax.swing.JTextField();
        jTextFieldData29 = new javax.swing.JTextField();
        jTextFieldData30 = new javax.swing.JTextField();
        jTextFieldData31 = new javax.swing.JTextField();
        jTextFieldData32 = new javax.swing.JTextField();
        jTextFieldData33 = new javax.swing.JTextField();
        jTextFieldData34 = new javax.swing.JTextField();
        jTextFieldData35 = new javax.swing.JTextField();
        jTextFieldData36 = new javax.swing.JTextField();
        jTextFieldData37 = new javax.swing.JTextField();
        jTextFieldData38 = new javax.swing.JTextField();
        jTextFieldData39 = new javax.swing.JTextField();
        jTextFieldData40 = new javax.swing.JTextField();
        jTextFieldData41 = new javax.swing.JTextField();
        jTextFieldData42 = new javax.swing.JTextField();
        jTextFieldData43 = new javax.swing.JTextField();
        jTextFieldData44 = new javax.swing.JTextField();
        jTextFieldData45 = new javax.swing.JTextField();
        jTextFieldData46 = new javax.swing.JTextField();
        jTextFieldData47 = new javax.swing.JTextField();
        jTextFieldData48 = new javax.swing.JTextField();
        jTextFieldData49 = new javax.swing.JTextField();
        jTextFieldData50 = new javax.swing.JTextField();
        jTextFieldData51 = new javax.swing.JTextField();
        jTextFieldData52 = new javax.swing.JTextField();
        jTextFieldData53 = new javax.swing.JTextField();
        jTextFieldData54 = new javax.swing.JTextField();
        jTextFieldData55 = new javax.swing.JTextField();
        jTextFieldData56 = new javax.swing.JTextField();
        jTextFieldData57 = new javax.swing.JTextField();
        jTextFieldData58 = new javax.swing.JTextField();
        jTextFieldData59 = new javax.swing.JTextField();
        jTextFieldData60 = new javax.swing.JTextField();
        jTextFieldData61 = new javax.swing.JTextField();
        jTextFieldData62 = new javax.swing.JTextField();
        jTextFieldData63 = new javax.swing.JTextField();
        jPanelFilter = new javax.swing.JPanel();
        jLabel6 = new javax.swing.JLabel();
        jLabel19 = new javax.swing.JLabel();
        jTextFieldIDFrom = new javax.swing.JTextField();
        jTextFieldIDTo = new javax.swing.JTextField();
        jButtonFilterSet = new javax.swing.JButton();
        jCheckBoxFilterExtended = new javax.swing.JCheckBox();
        jRadioFilterOpen = new javax.swing.JRadioButton();
        jRadioFilterClose = new javax.swing.JRadioButton();
        jRadioFilterCustom = new javax.swing.JRadioButton();
        jButtonFilterQuery = new javax.swing.JButton();
        jPanelConfiguration = new javax.swing.JPanel();
        jComboBoxParameter = new javax.swing.JComboBox();
        jLabel11 = new javax.swing.JLabel();
        jButtonGet = new javax.swing.JButton();
        jLayeredPaneConfiguration = new javax.swing.JLayeredPane();
        jPanelDeviceNumber = new javax.swing.JPanel();
        jLabel14 = new javax.swing.JLabel();
        jSpinnerDeviceNumber = new javax.swing.JSpinner();
        jPanelLogPath = new javax.swing.JPanel();
        jLabel16 = new javax.swing.JLabel();
        jScrollPanePath = new javax.swing.JScrollPane();
        jTextAreaPath = new javax.swing.JTextArea();
        jButtonBrowse = new javax.swing.JButton();
        jPanelLogConfigure = new javax.swing.JPanel();
        jCheckBoxRead = new javax.swing.JCheckBox();
        jCheckBoxEntry = new javax.swing.JCheckBox();
        jCheckBoxLeave = new javax.swing.JCheckBox();
        jCheckBoxWrite = new javax.swing.JCheckBox();
        jCheckBoxParameter = new javax.swing.JCheckBox();
        jPanelActivation = new javax.swing.JPanel();
        jLabel13 = new javax.swing.JLabel();
        jRadioButtonOFF = new javax.swing.JRadioButton();
        jRadioButtonON = new javax.swing.JRadioButton();
        jPanelTraceSize = new javax.swing.JPanel();
        jLabel20 = new javax.swing.JLabel();
        jSpinnerTraceSize = new javax.swing.JSpinner();
        jPanelTraceConfigure = new javax.swing.JPanel();
        jCheckBoxSingle = new javax.swing.JCheckBox();
        jCheckBoxSegmented = new javax.swing.JCheckBox();
        jCheckBoxDate = new javax.swing.JCheckBox();
        jCheckBoxTime = new javax.swing.JCheckBox();
        jCheckBoxOverwrite = new javax.swing.JCheckBox();
        jButtonSet = new javax.swing.JButton();
        jScrollPaneParameterDescription = new javax.swing.JScrollPane();
        jTextAreaParameterDescription = new javax.swing.JTextArea();
        jLabel17 = new javax.swing.JLabel();
        jLabel18 = new javax.swing.JLabel();
        jButtonClose = new javax.swing.JButton();
        jLabel15 = new javax.swing.JLabel();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("I CAN Do It! - Basic");
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                formWindowClosing(evt);
            }
        });

        jPanelHardware.setBorder(javax.swing.BorderFactory.createTitledBorder("New Connections"));

        jLabel1.setText("Channel:");

        jLabel2.setText("Baud Rate:");

        jComboBoxChannel.setMaximumRowCount(15);
        jComboBoxChannel.setModel(new DefaultComboBoxModel(peak.can.basic.TPCANHandle.initializableChannels()));
        jComboBoxChannel.setMinimumSize(new java.awt.Dimension(128, 18));
        jComboBoxChannel.setPreferredSize(new java.awt.Dimension(128, 20));
        jComboBoxChannel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxChannelActionPerformed(evt);
            }
        });

        jComboBoxBaudrate.setMaximumRowCount(15);
        jComboBoxBaudrate.setModel(new DefaultComboBoxModel(peak.can.basic.TPCANBaudrate.values()));
        jComboBoxBaudrate.setMinimumSize(new java.awt.Dimension(128, 18));
        jComboBoxBaudrate.setPreferredSize(new java.awt.Dimension(128, 20));
        jComboBoxBaudrate.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxBaudrateActionPerformed(evt);
            }
        });

        jLabel3.setText("Port:");

        jComboBoxPort.setMaximumRowCount(15);
        jComboBoxPort.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "100", "120", "140", "200", "220", "240", "260", "278", "280", "2A0", "2C0", "2E0", "2E8", "2F8", "300", "320", "340", "360", "378", "380", "3BC", "3E0", "3E8", "3F8", " " }));
        jComboBoxPort.setMinimumSize(new java.awt.Dimension(128, 18));
        jComboBoxPort.setPreferredSize(new java.awt.Dimension(128, 20));

        jLabel4.setText("Int:");

        jComboBoxInterrupt.setMaximumRowCount(15);
        jComboBoxInterrupt.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "3", "4", "5", "7", "9", "10", "11", "12", "15" }));
        jComboBoxInterrupt.setMinimumSize(new java.awt.Dimension(128, 18));
        jComboBoxInterrupt.setPreferredSize(new java.awt.Dimension(128, 20));

        jLabel5.setText("Hardware Type:");

        jComboBoxHardwareType.setMaximumRowCount(15);
        jComboBoxHardwareType.setModel(new DefaultComboBoxModel(peak.can.basic.TPCANType.values()));
        jComboBoxHardwareType.setMinimumSize(new java.awt.Dimension(128, 18));
        jComboBoxHardwareType.setPreferredSize(new java.awt.Dimension(128, 20));

        jButtonConnect.setText("Connect");
        jButtonConnect.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonConnectActionPerformed(evt);
            }
        });

        jCheckBoxCanFd.setText("CAN-FD");
        jCheckBoxCanFd.setActionCommand("jCheckBoxCanFd");
        jCheckBoxCanFd.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxCanFdActionPerformed(evt);
            }
        });

        jTextAreaBitRateFd.setColumns(20);
        jTextAreaBitRateFd.setLineWrap(true);
        jTextAreaBitRateFd.setRows(3);
        jTextAreaBitRateFd.setText("f_clock_mhz=20, nom_brp=5, nom_tseg1=2, nom_tseg2=1, nom_sjw=1, data_brp=2, data_tseg1=3, data_tseg2=1, data_sjw=1");
        jTextAreaBitRateFd.setEnabled(false);
        jScrollPane1.setViewportView(jTextAreaBitRateFd);

        javax.swing.GroupLayout jPanelHardwareLayout = new javax.swing.GroupLayout(jPanelHardware);
        jPanelHardware.setLayout(jPanelHardwareLayout);
        jPanelHardwareLayout.setHorizontalGroup(
            jPanelHardwareLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelHardwareLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanelHardwareLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanelHardwareLayout.createSequentialGroup()
                        .addGroup(jPanelHardwareLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jComboBoxChannel, javax.swing.GroupLayout.Alignment.TRAILING, 0, 160, Short.MAX_VALUE)
                            .addComponent(jLabel1)
                            .addComponent(jLabel5)
                            .addComponent(jComboBoxHardwareType, 0, 160, Short.MAX_VALUE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jPanelHardwareLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel2)
                            .addGroup(jPanelHardwareLayout.createSequentialGroup()
                                .addGroup(jPanelHardwareLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(jComboBoxBaudrate, javax.swing.GroupLayout.PREFERRED_SIZE, 136, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addGroup(jPanelHardwareLayout.createSequentialGroup()
                                        .addGroup(jPanelHardwareLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                            .addComponent(jLabel3)
                                            .addComponent(jComboBoxPort, javax.swing.GroupLayout.PREFERRED_SIZE, 53, javax.swing.GroupLayout.PREFERRED_SIZE))
                                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                        .addGroup(jPanelHardwareLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                            .addComponent(jLabel4)
                                            .addComponent(jComboBoxInterrupt, javax.swing.GroupLayout.PREFERRED_SIZE, 55, javax.swing.GroupLayout.PREFERRED_SIZE))))
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addGroup(jPanelHardwareLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(jCheckBoxCanFd)
                                    .addComponent(jButtonConnect)))))
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.Alignment.TRAILING))
                .addContainerGap())
        );
        jPanelHardwareLayout.setVerticalGroup(
            jPanelHardwareLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelHardwareLayout.createSequentialGroup()
                .addGroup(jPanelHardwareLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel2)
                    .addComponent(jLabel1))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanelHardwareLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jComboBoxBaudrate, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jComboBoxChannel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jButtonConnect))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanelHardwareLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel3)
                    .addComponent(jLabel4)
                    .addComponent(jLabel5))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanelHardwareLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jComboBoxPort, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jComboBoxInterrupt, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jComboBoxHardwareType, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jCheckBoxCanFd))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 65, Short.MAX_VALUE)
                .addContainerGap())
        );

        jPanelNewConnection.setBorder(javax.swing.BorderFactory.createTitledBorder("Connected Channels"));

        jLabel61.setText("Channel Handle:");

        jComboBoxConnectedChannel.setMaximumRowCount(15);
        jComboBoxConnectedChannel.setMinimumSize(new java.awt.Dimension(128, 18));
        jComboBoxConnectedChannel.setPreferredSize(new java.awt.Dimension(128, 20));
        jComboBoxConnectedChannel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxConnectedChannelActionPerformed(evt);
            }
        });

        jButtonRelease.setText("Release");
        jButtonRelease.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonReleaseActionPerformed(evt);
            }
        });

        jLabel62.setText("Working Channel:");

        jButtonPause.setText("Pause");
        jButtonPause.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonStartOrPauseActionPerformed(evt);
            }
        });

        jButtonStart.setText("Start");
        jButtonStart.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonStartOrPauseActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanelNewConnectionLayout = new javax.swing.GroupLayout(jPanelNewConnection);
        jPanelNewConnection.setLayout(jPanelNewConnectionLayout);
        jPanelNewConnectionLayout.setHorizontalGroup(
            jPanelNewConnectionLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelNewConnectionLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanelNewConnectionLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel61)
                    .addComponent(jLabel62)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanelNewConnectionLayout.createSequentialGroup()
                        .addComponent(jComboBoxConnectedChannel, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jButtonRelease))
                    .addGroup(jPanelNewConnectionLayout.createSequentialGroup()
                        .addComponent(jButtonPause)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonStart)))
                .addContainerGap())
        );
        jPanelNewConnectionLayout.setVerticalGroup(
            jPanelNewConnectionLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelNewConnectionLayout.createSequentialGroup()
                .addComponent(jLabel61)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanelNewConnectionLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jComboBoxConnectedChannel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jButtonRelease))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel62)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanelNewConnectionLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jButtonPause)
                    .addComponent(jButtonStart))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jPanelInfo.setBorder(javax.swing.BorderFactory.createTitledBorder("Information"));

        jTexteAreaInfo.setEditable(false);
        jTexteAreaInfo.setColumns(20);
        jTexteAreaInfo.setLineWrap(true);
        jTexteAreaInfo.setRows(5);
        jTexteAreaInfo.setText("Select a Hardware and a configuration for it. Then click \"Initialize\" button");
        jScrollPaneInfo.setViewportView(jTexteAreaInfo);

        javax.swing.GroupLayout jPanelInfoLayout = new javax.swing.GroupLayout(jPanelInfo);
        jPanelInfo.setLayout(jPanelInfoLayout);
        jPanelInfoLayout.setHorizontalGroup(
            jPanelInfoLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelInfoLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jScrollPaneInfo)
                .addContainerGap())
        );
        jPanelInfoLayout.setVerticalGroup(
            jPanelInfoLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelInfoLayout.createSequentialGroup()
                .addComponent(jScrollPaneInfo, javax.swing.GroupLayout.PREFERRED_SIZE, 100, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jPanelRead.setBorder(javax.swing.BorderFactory.createTitledBorder("Read Messages"));

        jTableMessage.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {
                "Type", "ID", "Length", "Data", "Count", "Rcv Time"
            }
        ) {
            Class[] types = new Class [] {
                java.lang.String.class, java.lang.String.class, java.lang.String.class, java.lang.String.class, java.lang.String.class, java.lang.Object.class
            };
            boolean[] canEdit = new boolean [] {
                false, false, false, false, false, false
            };

            public Class getColumnClass(int columnIndex) {
                return types [columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit [columnIndex];
            }
        });
        jTableMessage.getTableHeader().setReorderingAllowed(false);
        jScrollPane2.setViewportView(jTableMessage);

        jCheckBoxTimeStamp.setText("Show Time Stamp");
        jCheckBoxTimeStamp.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxTimeStampActionPerformed(evt);
            }
        });

        jLabel10.setText("Read Method:");

        buttonGroupReadMode.add(jRadioButtonTimer);
        jRadioButtonTimer.setSelected(true);
        jRadioButtonTimer.setText("By Timer");
        jRadioButtonTimer.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButtonTimerActionPerformed(evt);
            }
        });

        buttonGroupReadMode.add(jRadioButtonEvent);
        jRadioButtonEvent.setText("By Event");
        jRadioButtonEvent.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButtonEventActionPerformed(evt);
            }
        });

        jButtonReadClear.setText("Clear");
        jButtonReadClear.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonReadClearActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanelReadLayout = new javax.swing.GroupLayout(jPanelRead);
        jPanelRead.setLayout(jPanelReadLayout);
        jPanelReadLayout.setHorizontalGroup(
            jPanelReadLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelReadLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanelReadLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jScrollPane2)
                    .addGroup(jPanelReadLayout.createSequentialGroup()
                        .addComponent(jLabel10)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jRadioButtonTimer)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jRadioButtonEvent)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(jCheckBoxTimeStamp)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jButtonReadClear)))
                .addContainerGap())
        );
        jPanelReadLayout.setVerticalGroup(
            jPanelReadLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelReadLayout.createSequentialGroup()
                .addGroup(jPanelReadLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanelReadLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(jLabel10)
                        .addComponent(jRadioButtonTimer)
                        .addComponent(jRadioButtonEvent))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanelReadLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(jButtonReadClear)
                        .addComponent(jCheckBoxTimeStamp)))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane2, javax.swing.GroupLayout.PREFERRED_SIZE, 79, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );

        jPanelWrite.setBorder(javax.swing.BorderFactory.createTitledBorder("Write Messages"));

        jTextFieldWriteID.setText("0");
        jTextFieldWriteID.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldWriteIDFocusLost(evt);
            }
        });
        jTextFieldWriteID.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldWriteIDKeyTyped(evt);
            }
        });

        jLabel7.setText("ID (Hex):");

        jSpinnerLength.setModel(new javax.swing.SpinnerNumberModel(8, 0, 8, 1));
        jSpinnerLength.setValue(8);
        jSpinnerLength.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                jSpinnerLengthStateChanged(evt);
            }
        });

        jLabel8.setText("DLC:");

        jButtonWrite.setText("Write Message");
        jButtonWrite.setEnabled(false);
        jButtonWrite.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonWriteActionPerformed(evt);
            }
        });

        jCheckBoxWriteExtended.setText("Extended Frame");
        jCheckBoxWriteExtended.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jCheckBoxWriteExtended.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxWriteExtendedActionPerformed(evt);
            }
        });

        jCheckBoxWriteRemote.setText("RTR");
        jCheckBoxWriteRemote.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxWriteRemoteActionPerformed(evt);
            }
        });

        jTextFieldSendTiming.setText("100");
        jTextFieldSendTiming.setToolTipText("");
        jTextFieldSendTiming.setEnabled(false);

        jLabel12.setText("sending interval in ms:");

        jCheckBoxSendingThread.setText("enable sending Random Data on ID 0x400");
        jCheckBoxSendingThread.setEnabled(false);
        jCheckBoxSendingThread.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxSendingThreadActionPerformed(evt);
            }
        });

        jLabel21.setText("Length:");

        jTextFieldWriteID1.setText("0");
        jTextFieldWriteID1.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldWriteID1FocusLost(evt);
            }
        });
        jTextFieldWriteID1.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldWriteID1KeyTyped(evt);
            }
        });

        jCheckBoxWriteFd.setText("FD");
        jCheckBoxWriteFd.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxWriteFdActionPerformed(evt);
            }
        });

        jCheckBoxWriteBrs.setText("BRS");
        jCheckBoxWriteBrs.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxWriteBrsActionPerformed(evt);
            }
        });

        jTextFieldData0.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData0.setText("00");
        jTextFieldData0.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData0.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        jTextFieldData1.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData1.setText("00");
        jTextFieldData1.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData1.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        jTextFieldData2.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData2.setText("00");
        jTextFieldData2.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData2.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        jTextFieldData3.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData3.setText("00");
        jTextFieldData3.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData3.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        jTextFieldData4.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData4.setText("00");
        jTextFieldData4.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData4.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        jTextFieldData5.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData5.setText("00");
        jTextFieldData5.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData5.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        jTextFieldData6.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData6.setText("00");
        jTextFieldData6.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData6.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        jTextFieldData7.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData7.setText("00");
        jTextFieldData7.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData7.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        jTextFieldData8.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData8.setText("00");
        jTextFieldData8.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData8.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        jTextFieldData9.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData9.setText("00");
        jTextFieldData9.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData9.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        jTextFieldData10.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData10.setText("00");
        jTextFieldData10.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData10.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        jTextFieldData11.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData11.setText("00");
        jTextFieldData11.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData11.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        jTextFieldData12.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData12.setText("00");
        jTextFieldData12.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData12.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        jTextFieldData13.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData13.setText("00");
        jTextFieldData13.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData13.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        jTextFieldData14.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData14.setText("00");
        jTextFieldData14.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData14.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        jTextFieldData15.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData15.setText("00");
        jTextFieldData15.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData15.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        jTextFieldData16.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData16.setText("00");
        jTextFieldData16.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData16.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        jTextFieldData17.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData17.setText("00");
        jTextFieldData17.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData17.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        jTextFieldData18.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData18.setText("00");
        jTextFieldData18.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData18.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        jTextFieldData19.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData19.setText("00");
        jTextFieldData19.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData19.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        jTextFieldData20.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData20.setText("00");
        jTextFieldData20.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData20.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        jTextFieldData21.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData21.setText("00");
        jTextFieldData21.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData21.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        jTextFieldData22.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData22.setText("00");
        jTextFieldData22.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData22.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        jTextFieldData23.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData23.setText("00");
        jTextFieldData23.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData23.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        jTextFieldData24.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData24.setText("00");
        jTextFieldData24.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData24.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        jTextFieldData25.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData25.setText("00");
        jTextFieldData25.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData25.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        jTextFieldData26.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData26.setText("00");
        jTextFieldData26.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData26.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        jTextFieldData27.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData27.setText("00");
        jTextFieldData27.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData27.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        jTextFieldData28.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData28.setText("00");
        jTextFieldData28.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData28.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        jTextFieldData29.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData29.setText("00");
        jTextFieldData29.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData29.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        jTextFieldData30.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData30.setText("00");
        jTextFieldData30.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData30.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        jTextFieldData31.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData31.setText("00");
        jTextFieldData31.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData31.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        jTextFieldData32.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData32.setText("00");
        jTextFieldData32.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData32.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        jTextFieldData33.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData33.setText("00");
        jTextFieldData33.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData33.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        jTextFieldData34.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData34.setText("00");
        jTextFieldData34.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData34.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        jTextFieldData35.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData35.setText("00");
        jTextFieldData35.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData35.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        jTextFieldData36.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData36.setText("00");
        jTextFieldData36.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData36.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        jTextFieldData37.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData37.setText("00");
        jTextFieldData37.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData37.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        jTextFieldData38.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData38.setText("00");
        jTextFieldData38.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData38.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        jTextFieldData39.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData39.setText("00");
        jTextFieldData39.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData39.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        jTextFieldData40.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData40.setText("00");
        jTextFieldData40.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData40.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        jTextFieldData41.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData41.setText("00");
        jTextFieldData41.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData41.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        jTextFieldData42.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData42.setText("00");
        jTextFieldData42.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData42.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        jTextFieldData43.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData43.setText("00");
        jTextFieldData43.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData43.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        jTextFieldData44.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData44.setText("00");
        jTextFieldData44.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData44.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        jTextFieldData45.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData45.setText("00");
        jTextFieldData45.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData45.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        jTextFieldData46.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData46.setText("00");
        jTextFieldData46.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData46.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        jTextFieldData47.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData47.setText("00");
        jTextFieldData47.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData47.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        jTextFieldData48.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData48.setText("00");
        jTextFieldData48.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData48.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        jTextFieldData49.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData49.setText("00");
        jTextFieldData49.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData49.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        jTextFieldData50.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData50.setText("00");
        jTextFieldData50.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData50.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        jTextFieldData51.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData51.setText("00");
        jTextFieldData51.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData51.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        jTextFieldData52.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData52.setText("00");
        jTextFieldData52.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData52.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        jTextFieldData53.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData53.setText("00");
        jTextFieldData53.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData53.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        jTextFieldData54.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData54.setText("00");
        jTextFieldData54.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData54.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        jTextFieldData55.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData55.setText("00");
        jTextFieldData55.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData55.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        jTextFieldData56.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData56.setText("00");
        jTextFieldData56.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData56.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        jTextFieldData57.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData57.setText("00");
        jTextFieldData57.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData57.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        jTextFieldData58.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData58.setText("00");
        jTextFieldData58.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData58.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        jTextFieldData59.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData59.setText("00");
        jTextFieldData59.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData59.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        jTextFieldData60.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData60.setText("00");
        jTextFieldData60.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData60.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        jTextFieldData61.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData61.setText("00");
        jTextFieldData61.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData61.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        jTextFieldData62.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData62.setText("00");
        jTextFieldData62.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData62.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        jTextFieldData63.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData63.setText("00");
        jTextFieldData63.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldDataFocusLost(evt);
            }
        });
        jTextFieldData63.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldDataKeyTyped(evt);
            }
        });

        javax.swing.GroupLayout jPanelWriteDataLayout = new javax.swing.GroupLayout(jPanelWriteData);
        jPanelWriteData.setLayout(jPanelWriteDataLayout);
        jPanelWriteDataLayout.setHorizontalGroup(
            jPanelWriteDataLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 494, Short.MAX_VALUE)
            .addGroup(jPanelWriteDataLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                .addGroup(jPanelWriteDataLayout.createSequentialGroup()
                    .addContainerGap()
                    .addGroup(jPanelWriteDataLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(jPanelWriteDataLayout.createSequentialGroup()
                            .addComponent(jTextFieldData0, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jTextFieldData1, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jTextFieldData2, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jTextFieldData3, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jTextFieldData4, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jTextFieldData5, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jTextFieldData6, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jTextFieldData7, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jTextFieldData8, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jTextFieldData9, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jTextFieldData10, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jTextFieldData11, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jTextFieldData12, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jTextFieldData13, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jTextFieldData14, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jTextFieldData15, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addGroup(jPanelWriteDataLayout.createSequentialGroup()
                            .addComponent(jTextFieldData16, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jTextFieldData17, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jTextFieldData18, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jTextFieldData19, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jTextFieldData20, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jTextFieldData21, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jTextFieldData22, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jTextFieldData23, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jTextFieldData24, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jTextFieldData25, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jTextFieldData26, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jTextFieldData27, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jTextFieldData28, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jTextFieldData29, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jTextFieldData30, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jTextFieldData31, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addGroup(jPanelWriteDataLayout.createSequentialGroup()
                            .addComponent(jTextFieldData32, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jTextFieldData33, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jTextFieldData34, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jTextFieldData35, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jTextFieldData36, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jTextFieldData37, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jTextFieldData38, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jTextFieldData39, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jTextFieldData40, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jTextFieldData41, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jTextFieldData42, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jTextFieldData43, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jTextFieldData44, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jTextFieldData45, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jTextFieldData46, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jTextFieldData47, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addGroup(jPanelWriteDataLayout.createSequentialGroup()
                            .addComponent(jTextFieldData48, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jTextFieldData49, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jTextFieldData50, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jTextFieldData51, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jTextFieldData52, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jTextFieldData53, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jTextFieldData54, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jTextFieldData55, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jTextFieldData56, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jTextFieldData57, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jTextFieldData58, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jTextFieldData59, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jTextFieldData60, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jTextFieldData61, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jTextFieldData62, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jTextFieldData63, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)))
                    .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
        );
        jPanelWriteDataLayout.setVerticalGroup(
            jPanelWriteDataLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 0, Short.MAX_VALUE)
            .addGroup(jPanelWriteDataLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                .addGroup(jPanelWriteDataLayout.createSequentialGroup()
                    .addGap(1, 1, 1)
                    .addGroup(jPanelWriteDataLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(jTextFieldData0, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jTextFieldData3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jTextFieldData4, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jTextFieldData5, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jTextFieldData6, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jTextFieldData7, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jTextFieldData1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jTextFieldData2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jTextFieldData8, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jTextFieldData14, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jTextFieldData13, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jTextFieldData12, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jTextFieldData11, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jTextFieldData10, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jTextFieldData9, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jTextFieldData15, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                    .addGroup(jPanelWriteDataLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(jTextFieldData16, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jTextFieldData19, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jTextFieldData20, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jTextFieldData21, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jTextFieldData22, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jTextFieldData23, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jTextFieldData17, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jTextFieldData18, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jTextFieldData24, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jTextFieldData30, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jTextFieldData29, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jTextFieldData28, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jTextFieldData27, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jTextFieldData26, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jTextFieldData25, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jTextFieldData31, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                    .addGroup(jPanelWriteDataLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(jTextFieldData32, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jTextFieldData35, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jTextFieldData36, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jTextFieldData37, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jTextFieldData38, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jTextFieldData39, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jTextFieldData33, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jTextFieldData34, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jTextFieldData40, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jTextFieldData46, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jTextFieldData45, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jTextFieldData44, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jTextFieldData43, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jTextFieldData42, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jTextFieldData41, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jTextFieldData47, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                    .addGroup(jPanelWriteDataLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(jTextFieldData48, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jTextFieldData51, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jTextFieldData52, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jTextFieldData53, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jTextFieldData54, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jTextFieldData55, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jTextFieldData49, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jTextFieldData50, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jTextFieldData56, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jTextFieldData62, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jTextFieldData61, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jTextFieldData60, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jTextFieldData59, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jTextFieldData58, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jTextFieldData57, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jTextFieldData63, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
        );

        javax.swing.GroupLayout jPanelWriteLayout = new javax.swing.GroupLayout(jPanelWrite);
        jPanelWrite.setLayout(jPanelWriteLayout);
        jPanelWriteLayout.setHorizontalGroup(
            jPanelWriteLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelWriteLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanelWriteLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanelWriteLayout.createSequentialGroup()
                        .addComponent(jCheckBoxSendingThread)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jLabel12)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jTextFieldSendTiming, javax.swing.GroupLayout.PREFERRED_SIZE, 48, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addComponent(jPanelWriteData, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanelWriteLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanelWriteLayout.createSequentialGroup()
                        .addGroup(jPanelWriteLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jTextFieldWriteID, javax.swing.GroupLayout.PREFERRED_SIZE, 65, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jLabel7))
                        .addGap(18, 18, 18)
                        .addGroup(jPanelWriteLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel8, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(jSpinnerLength, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addGap(18, 18, 18)
                        .addGroup(jPanelWriteLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel21, javax.swing.GroupLayout.DEFAULT_SIZE, 71, Short.MAX_VALUE)
                            .addGroup(jPanelWriteLayout.createSequentialGroup()
                                .addComponent(jTextFieldWriteID1, javax.swing.GroupLayout.PREFERRED_SIZE, 65, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 6, Short.MAX_VALUE)))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonWrite, javax.swing.GroupLayout.PREFERRED_SIZE, 123, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                    .addGroup(jPanelWriteLayout.createSequentialGroup()
                        .addGroup(jPanelWriteLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jCheckBoxWriteExtended)
                            .addComponent(jCheckBoxWriteFd))
                        .addGap(18, 18, 18)
                        .addGroup(jPanelWriteLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jCheckBoxWriteBrs)
                            .addComponent(jCheckBoxWriteRemote))
                        .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))))
        );
        jPanelWriteLayout.setVerticalGroup(
            jPanelWriteLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelWriteLayout.createSequentialGroup()
                .addGroup(jPanelWriteLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanelWriteLayout.createSequentialGroup()
                        .addGroup(jPanelWriteLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(jPanelWriteLayout.createSequentialGroup()
                                .addGroup(jPanelWriteLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                    .addComponent(jLabel7)
                                    .addComponent(jLabel8)
                                    .addComponent(jLabel21))
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addGroup(jPanelWriteLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                    .addComponent(jTextFieldWriteID, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(jSpinnerLength, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(jTextFieldWriteID1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                                .addGroup(jPanelWriteLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                    .addComponent(jCheckBoxWriteExtended)
                                    .addComponent(jCheckBoxWriteRemote))
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                                .addGroup(jPanelWriteLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                    .addComponent(jCheckBoxWriteFd)
                                    .addComponent(jCheckBoxWriteBrs)))
                            .addGroup(jPanelWriteLayout.createSequentialGroup()
                                .addContainerGap()
                                .addComponent(jPanelWriteData, javax.swing.GroupLayout.PREFERRED_SIZE, 108, javax.swing.GroupLayout.PREFERRED_SIZE)))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jPanelWriteLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jCheckBoxSendingThread)
                            .addComponent(jLabel12)
                            .addComponent(jTextFieldSendTiming, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                    .addComponent(jButtonWrite))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jPanelFilter.setBorder(javax.swing.BorderFactory.createTitledBorder("Message Filter"));

        jLabel6.setText("From:");

        jLabel19.setText("To:");

        jTextFieldIDFrom.setColumns(3);
        jTextFieldIDFrom.setText("0");
        jTextFieldIDFrom.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldIDFromFocusLost(evt);
            }
        });
        jTextFieldIDFrom.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldIDFromKeyTyped(evt);
            }
        });

        jTextFieldIDTo.setText("0");
        jTextFieldIDTo.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldIDToFocusLost(evt);
            }
        });
        jTextFieldIDTo.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldIDToKeyTyped(evt);
            }
        });

        jButtonFilterSet.setText("Set");
        jButtonFilterSet.setEnabled(false);
        jButtonFilterSet.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFilterSetActionPerformed(evt);
            }
        });

        jCheckBoxFilterExtended.setText("Extended");
        jCheckBoxFilterExtended.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxFilterExtendedActionPerformed(evt);
            }
        });

        buttonGroupFilter.add(jRadioFilterOpen);
        jRadioFilterOpen.setSelected(true);
        jRadioFilterOpen.setText("Open");

        buttonGroupFilter.add(jRadioFilterClose);
        jRadioFilterClose.setText("Close");

        buttonGroupFilter.add(jRadioFilterCustom);
        jRadioFilterCustom.setText("Custom (expand)");

        jButtonFilterQuery.setText("Query");
        jButtonFilterQuery.setEnabled(false);
        jButtonFilterQuery.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFilterQueryActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanelFilterLayout = new javax.swing.GroupLayout(jPanelFilter);
        jPanelFilter.setLayout(jPanelFilterLayout);
        jPanelFilterLayout.setHorizontalGroup(
            jPanelFilterLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelFilterLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jCheckBoxFilterExtended)
                .addGap(16, 16, 16)
                .addComponent(jRadioFilterOpen)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jRadioFilterClose)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jRadioFilterCustom)
                .addGap(10, 10, 10)
                .addComponent(jLabel6)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jTextFieldIDFrom, javax.swing.GroupLayout.PREFERRED_SIZE, 66, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addComponent(jLabel19)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jTextFieldIDTo, javax.swing.GroupLayout.PREFERRED_SIZE, 67, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jButtonFilterSet, javax.swing.GroupLayout.PREFERRED_SIZE, 65, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(11, 11, 11)
                .addComponent(jButtonFilterQuery)
                .addContainerGap())
        );
        jPanelFilterLayout.setVerticalGroup(
            jPanelFilterLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelFilterLayout.createSequentialGroup()
                .addGroup(jPanelFilterLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jRadioFilterOpen)
                    .addComponent(jRadioFilterClose)
                    .addComponent(jRadioFilterCustom)
                    .addComponent(jLabel6)
                    .addComponent(jTextFieldIDFrom, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jTextFieldIDTo, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel19)
                    .addComponent(jCheckBoxFilterExtended)
                    .addComponent(jButtonFilterSet)
                    .addComponent(jButtonFilterQuery))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jPanelConfiguration.setBorder(javax.swing.BorderFactory.createTitledBorder("Configuration"));

        jComboBoxParameter.setMaximumRowCount(16);
        jComboBoxParameter.setModel(new DefaultComboBoxModel(peak.can.basic.TPCANParameter.customizableParameters()));
        jComboBoxParameter.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxParameterActionPerformed(evt);
            }
        });

        jLabel11.setText("Parameter:");

        jButtonGet.setText("Get");
        jButtonGet.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonGetActionPerformed(evt);
            }
        });

        jLabel14.setText("Device Number:");

        jSpinnerDeviceNumber.setModel(new javax.swing.SpinnerNumberModel(1, 1, 429496729, 1));

        javax.swing.GroupLayout jPanelDeviceNumberLayout = new javax.swing.GroupLayout(jPanelDeviceNumber);
        jPanelDeviceNumber.setLayout(jPanelDeviceNumberLayout);
        jPanelDeviceNumberLayout.setHorizontalGroup(
            jPanelDeviceNumberLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelDeviceNumberLayout.createSequentialGroup()
                .addComponent(jLabel14)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jSpinnerDeviceNumber, javax.swing.GroupLayout.PREFERRED_SIZE, 89, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(41, Short.MAX_VALUE))
        );
        jPanelDeviceNumberLayout.setVerticalGroup(
            jPanelDeviceNumberLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelDeviceNumberLayout.createSequentialGroup()
                .addGroup(jPanelDeviceNumberLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel14)
                    .addComponent(jSpinnerDeviceNumber, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(70, Short.MAX_VALUE))
        );

        jLayeredPaneConfiguration.add(jPanelDeviceNumber);
        jPanelDeviceNumber.setBounds(0, 0, 210, 90);

        jLabel16.setText("Log File Path:");

        jTextAreaPath.setEditable(false);
        jTextAreaPath.setColumns(20);
        jTextAreaPath.setLineWrap(true);
        jTextAreaPath.setRows(5);
        jScrollPanePath.setViewportView(jTextAreaPath);

        jButtonBrowse.setText("Browse");
        jButtonBrowse.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonBrowseActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanelLogPathLayout = new javax.swing.GroupLayout(jPanelLogPath);
        jPanelLogPath.setLayout(jPanelLogPathLayout);
        jPanelLogPathLayout.setHorizontalGroup(
            jPanelLogPathLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelLogPathLayout.createSequentialGroup()
                .addGroup(jPanelLogPathLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel16)
                    .addComponent(jButtonBrowse, javax.swing.GroupLayout.PREFERRED_SIZE, 150, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jScrollPanePath, javax.swing.GroupLayout.PREFERRED_SIZE, 199, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        jPanelLogPathLayout.setVerticalGroup(
            jPanelLogPathLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanelLogPathLayout.createSequentialGroup()
                .addComponent(jLabel16)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jScrollPanePath, javax.swing.GroupLayout.PREFERRED_SIZE, 31, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jButtonBrowse, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addContainerGap())
        );

        jLayeredPaneConfiguration.add(jPanelLogPath);
        jPanelLogPath.setBounds(0, 0, 230, 90);

        jCheckBoxRead.setText("Read");

        jCheckBoxEntry.setText("Entry");

        jCheckBoxLeave.setText("Leave");

        jCheckBoxWrite.setText("Write");

        jCheckBoxParameter.setText("Parameter");

        javax.swing.GroupLayout jPanelLogConfigureLayout = new javax.swing.GroupLayout(jPanelLogConfigure);
        jPanelLogConfigure.setLayout(jPanelLogConfigureLayout);
        jPanelLogConfigureLayout.setHorizontalGroup(
            jPanelLogConfigureLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelLogConfigureLayout.createSequentialGroup()
                .addGroup(jPanelLogConfigureLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanelLogConfigureLayout.createSequentialGroup()
                        .addGroup(jPanelLogConfigureLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jCheckBoxLeave)
                            .addComponent(jCheckBoxEntry))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jPanelLogConfigureLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jCheckBoxRead)
                            .addComponent(jCheckBoxWrite)))
                    .addComponent(jCheckBoxParameter))
                .addContainerGap(64, Short.MAX_VALUE))
        );
        jPanelLogConfigureLayout.setVerticalGroup(
            jPanelLogConfigureLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelLogConfigureLayout.createSequentialGroup()
                .addGroup(jPanelLogConfigureLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jCheckBoxLeave)
                    .addComponent(jCheckBoxWrite))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanelLogConfigureLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jCheckBoxEntry)
                    .addComponent(jCheckBoxRead))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jCheckBoxParameter)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jLayeredPaneConfiguration.add(jPanelLogConfigure);
        jPanelLogConfigure.setBounds(0, 0, 170, 70);

        jLabel13.setText("Activation:");

        buttonGroupONOFF.add(jRadioButtonOFF);
        jRadioButtonOFF.setText("OFF");

        buttonGroupONOFF.add(jRadioButtonON);
        jRadioButtonON.setSelected(true);
        jRadioButtonON.setText("ON");

        javax.swing.GroupLayout jPanelActivationLayout = new javax.swing.GroupLayout(jPanelActivation);
        jPanelActivation.setLayout(jPanelActivationLayout);
        jPanelActivationLayout.setHorizontalGroup(
            jPanelActivationLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelActivationLayout.createSequentialGroup()
                .addComponent(jLabel13)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jRadioButtonON)
                .addGap(2, 2, 2)
                .addComponent(jRadioButtonOFF)
                .addContainerGap(24, Short.MAX_VALUE))
        );
        jPanelActivationLayout.setVerticalGroup(
            jPanelActivationLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelActivationLayout.createSequentialGroup()
                .addGroup(jPanelActivationLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel13)
                    .addComponent(jRadioButtonON)
                    .addComponent(jRadioButtonOFF))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jLayeredPaneConfiguration.add(jPanelActivation);
        jPanelActivation.setBounds(0, 0, 170, 20);

        jPanelTraceSize.setMinimumSize(new java.awt.Dimension(210, 110));

        jLabel20.setText("Trace Size in MB:");
        jLabel20.setToolTipText("");

        jSpinnerTraceSize.setModel(new javax.swing.SpinnerNumberModel(1, 1, 429496729, 1));

        javax.swing.GroupLayout jPanelTraceSizeLayout = new javax.swing.GroupLayout(jPanelTraceSize);
        jPanelTraceSize.setLayout(jPanelTraceSizeLayout);
        jPanelTraceSizeLayout.setHorizontalGroup(
            jPanelTraceSizeLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelTraceSizeLayout.createSequentialGroup()
                .addComponent(jLabel20)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jSpinnerTraceSize, javax.swing.GroupLayout.PREFERRED_SIZE, 89, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(36, Short.MAX_VALUE))
        );
        jPanelTraceSizeLayout.setVerticalGroup(
            jPanelTraceSizeLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelTraceSizeLayout.createSequentialGroup()
                .addGroup(jPanelTraceSizeLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel20)
                    .addComponent(jSpinnerTraceSize, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(0, 90, Short.MAX_VALUE))
        );

        jLayeredPaneConfiguration.add(jPanelTraceSize);
        jPanelTraceSize.setBounds(0, 0, 210, 20);

        jPanelTraceConfigure.setEnabled(false);
        jPanelTraceConfigure.setName(""); // NOI18N
        jPanelTraceConfigure.setOpaque(false);
        jPanelTraceConfigure.setPreferredSize(new java.awt.Dimension(170, 120));

        jCheckBoxSingle.setText("Single");
        jCheckBoxSingle.setToolTipText("");
        jCheckBoxSingle.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxSingleActionPerformed(evt);
            }
        });

        jCheckBoxSegmented.setText("Segmented");
        jCheckBoxSegmented.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxSegmentedActionPerformed(evt);
            }
        });

        jCheckBoxDate.setText("Date");
        jCheckBoxDate.setToolTipText("");

        jCheckBoxTime.setText("Time");
        jCheckBoxTime.setToolTipText("");

        jCheckBoxOverwrite.setText("Overwrite");
        jCheckBoxOverwrite.setToolTipText("");

        javax.swing.GroupLayout jPanelTraceConfigureLayout = new javax.swing.GroupLayout(jPanelTraceConfigure);
        jPanelTraceConfigure.setLayout(jPanelTraceConfigureLayout);
        jPanelTraceConfigureLayout.setHorizontalGroup(
            jPanelTraceConfigureLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelTraceConfigureLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanelTraceConfigureLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanelTraceConfigureLayout.createSequentialGroup()
                        .addGroup(jPanelTraceConfigureLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jCheckBoxSingle)
                            .addComponent(jCheckBoxDate))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addGroup(jPanelTraceConfigureLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jCheckBoxSegmented)
                            .addComponent(jCheckBoxOverwrite)))
                    .addComponent(jCheckBoxTime))
                .addContainerGap(30, Short.MAX_VALUE))
        );
        jPanelTraceConfigureLayout.setVerticalGroup(
            jPanelTraceConfigureLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelTraceConfigureLayout.createSequentialGroup()
                .addGroup(jPanelTraceConfigureLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jCheckBoxSingle)
                    .addComponent(jCheckBoxSegmented))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanelTraceConfigureLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jCheckBoxDate)
                    .addComponent(jCheckBoxOverwrite))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jCheckBoxTime))
        );

        jLayeredPaneConfiguration.add(jPanelTraceConfigure);
        jPanelTraceConfigure.setBounds(0, 0, 170, 90);

        jButtonSet.setText("Set");
        jButtonSet.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonSetActionPerformed(evt);
            }
        });

        jTextAreaParameterDescription.setColumns(20);
        jTextAreaParameterDescription.setLineWrap(true);
        jTextAreaParameterDescription.setRows(5);
        jTextAreaParameterDescription.setWrapStyleWord(true);
        jScrollPaneParameterDescription.setViewportView(jTextAreaParameterDescription);

        jLabel17.setText("Parameter Value(s):");

        jLabel18.setText("Function:");

        javax.swing.GroupLayout jPanelConfigurationLayout = new javax.swing.GroupLayout(jPanelConfiguration);
        jPanelConfiguration.setLayout(jPanelConfigurationLayout);
        jPanelConfigurationLayout.setHorizontalGroup(
            jPanelConfigurationLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelConfigurationLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanelConfigurationLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanelConfigurationLayout.createSequentialGroup()
                        .addGroup(jPanelConfigurationLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jScrollPaneParameterDescription)
                            .addComponent(jComboBoxParameter, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                        .addGap(18, 18, 18)
                        .addComponent(jLayeredPaneConfiguration, javax.swing.GroupLayout.PREFERRED_SIZE, 208, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED))
                    .addGroup(jPanelConfigurationLayout.createSequentialGroup()
                        .addComponent(jLabel11)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(jLabel17)
                        .addGap(38, 38, 38)))
                .addGroup(jPanelConfigurationLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanelConfigurationLayout.createSequentialGroup()
                        .addComponent(jButtonSet)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jButtonGet))
                    .addComponent(jLabel18))
                .addContainerGap())
        );
        jPanelConfigurationLayout.setVerticalGroup(
            jPanelConfigurationLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelConfigurationLayout.createSequentialGroup()
                .addGroup(jPanelConfigurationLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel11)
                    .addComponent(jLabel17)
                    .addComponent(jLabel18))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanelConfigurationLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanelConfigurationLayout.createSequentialGroup()
                        .addComponent(jComboBoxParameter, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jScrollPaneParameterDescription, javax.swing.GroupLayout.PREFERRED_SIZE, 0, Short.MAX_VALUE))
                    .addGroup(jPanelConfigurationLayout.createSequentialGroup()
                        .addGroup(jPanelConfigurationLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(jPanelConfigurationLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                .addComponent(jButtonGet)
                                .addComponent(jButtonSet))
                            .addComponent(jLayeredPaneConfiguration, javax.swing.GroupLayout.PREFERRED_SIZE, 95, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addGap(0, 0, Short.MAX_VALUE)))
                .addContainerGap())
        );

        jButtonClose.setText("Close");
        jButtonClose.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCloseActionPerformed(evt);
            }
        });

        jLabel15.setText("PCAN-Basic JAVA Demo 1.10.0  (c) 2014 PEAK-System Technik GmbH");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jPanelHardware, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jPanelNewConnection, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                    .addComponent(jPanelRead, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jPanelFilter, javax.swing.GroupLayout.Alignment.TRAILING, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jPanelWrite, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jPanelConfiguration, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jPanelInfo, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jLabel15, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jButtonClose)))
                .addGap(4, 4, 4))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(jPanelHardware, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jPanelNewConnection, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanelFilter, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(jPanelRead, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanelWrite, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanelConfiguration, javax.swing.GroupLayout.PREFERRED_SIZE, 144, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanelInfo, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jButtonClose)
                    .addComponent(jLabel15))
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jCheckBoxTimeStampActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jCheckBoxTimeStampActionPerformed
    {//GEN-HEADEREND:event_jCheckBoxTimeStampActionPerformed
        // Configure canReadThread to call the right CAN function
        if (canReadThread != null)
        {
            canReadThread.setReadTimeStamp(jCheckBoxTimeStamp.isSelected());
        }
        // Add or Remove column
        if (jCheckBoxTimeStamp.isSelected())
        {
            jTableMessage.getColumnModel().addColumn(columnTimeStamp);
        }
        else
        {
            jTableMessage.getColumnModel().removeColumn(columnTimeStamp);
        }
    }//GEN-LAST:event_jCheckBoxTimeStampActionPerformed

    private void jComboBoxConnectedChannelActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jComboBoxConnectedChannelActionPerformed
    {//GEN-HEADEREND:event_jComboBoxConnectedChannelActionPerformed
        //Updates UI
        UpdateUIButtons();
    }//GEN-LAST:event_jComboBoxConnectedChannelActionPerformed

    private void jButtonReleaseActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jButtonReleaseActionPerformed
    {//GEN-HEADEREND:event_jButtonReleaseActionPerformed
        TPCANStatus status;

        // Get Selected Item
        ChannelItem item = (ChannelItem) jComboBoxConnectedChannel.getModel().getSelectedItem();

        // If simple ChannelItem
        if (item != MarkAllChannelItem.getInstance())
        {
            // Unitializes current Channel
            status = uninitialize(item);
            if (status == TPCANStatus.PCAN_ERROR_OK)
            {
                // Remove item in collection
                connectedChannelCollection.remove(item);
                // Remove MarkAllChannelItem if need be
                if (connectedChannelCollection.size() == 2)
                {
                    connectedChannelCollection.remove(MarkAllChannelItem.getInstance());
                }
                showInfo(item.getHandle().toString() + " Successfully unitialized", false);
            }
        }
        // If MarkAllChannelItem
        else
        {
            // Unitializes each Channel
            for (ChannelItem subItem : connectedChannelCollection)
            {
                if (subItem != MarkAllChannelItem.getInstance())
                {
                    status = uninitialize(subItem);
                    if (status != TPCANStatus.PCAN_ERROR_OK)
                    {
                        return;
                    }
                }

            }
            // Remove all items in collection
            connectedChannelCollection.removeAllElements();
            showInfo("All Successfully unitialized", false);
        }

        // Update UI
        if (connectedChannelCollection.size() > 0)
        {
            jComboBoxConnectedChannel.setSelectedIndex(0);
        }
        else
        {
            jComboBoxConnectedChannel.removeAllItems();
        }
        jComboBoxConnectedChannel.updateUI();
        UpdateUIButtons();
    }//GEN-LAST:event_jButtonReleaseActionPerformed

    private void jRadioButtonTimerActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jRadioButtonTimerActionPerformed
    {//GEN-HEADEREND:event_jRadioButtonTimerActionPerformed
        changeReadMode(jRadioButtonTimer.isSelected());
    }//GEN-LAST:event_jRadioButtonTimerActionPerformed

    private void jRadioButtonEventActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jRadioButtonEventActionPerformed
    {//GEN-HEADEREND:event_jRadioButtonEventActionPerformed
        changeReadMode(jRadioButtonTimer.isSelected());
    }//GEN-LAST:event_jRadioButtonEventActionPerformed

    private void jButtonStartOrPauseActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jButtonStartOrPauseActionPerformed
    {//GEN-HEADEREND:event_jButtonStartOrPauseActionPerformed
        // Get targeted state
        boolean working = (evt.getSource() == jButtonStart) ? true : false;

        // Get Selected Item
        ChannelItem item = (ChannelItem) jComboBoxConnectedChannel.getModel().getSelectedItem();

        // If simple ChannelItem
        if (item != MarkAllChannelItem.getInstance())
        {
            changeChannelState(item, working);
        }
        // If MarkAllChannelItem, process all items
        else
        {
            for (ChannelItem subItem : connectedChannelCollection)
            {
                if (subItem != MarkAllChannelItem.getInstance())
                {
                    changeChannelState(subItem, working);
                }
            }   
        }
        // Update UI
        jComboBoxConnectedChannel.updateUI();
        UpdateUIButtons();
    }//GEN-LAST:event_jButtonStartOrPauseActionPerformed

    private void jComboBoxParameterActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jComboBoxParameterActionPerformed
    {//GEN-HEADEREND:event_jComboBoxParameterActionPerformed
        // Get selected Parameter
        TPCANParameter selectedParameter = (TPCANParameter) jComboBoxParameter.getSelectedItem();

        // Update selected Parameter description
        jTextAreaParameterDescription.setText(TPCANParameter.getParameterDescription(selectedParameter));

        // Hide all parameter UI
        jPanelDeviceNumber.setVisible(false);
        jPanelActivation.setVisible(false);
        jPanelLogConfigure.setVisible(false);
        jPanelLogPath.setVisible(false);
        jPanelTraceSize.setVisible(false);
        jPanelTraceConfigure.setVisible(false);
        jButtonGet.setEnabled(false);
        jButtonSet.setEnabled(false);


        // Switch selected Parameter and show/hide, enable/disable needed UI
        switch (selectedParameter)
        {
            case PCAN_DEVICE_NUMBER:
                // Verify Channel is USB device
                if (TPCANHandle.isPCANUSBHardware(getSelectedConnectedChannel()))
                {
                    jButtonSet.setEnabled(true);
                    jButtonGet.setEnabled(true);
                }
                jPanelDeviceNumber.setVisible(true);
                break;
            case PCAN_5VOLTS_POWER:
                // Verify Channel is USB or PC-Card  device
                if (TPCANHandle.isPCANUSBHardware(getSelectedConnectedChannel()) || TPCANHandle.isPCANPCCardHardware(getSelectedConnectedChannel()))
                {
                    jButtonSet.setEnabled(true);
                    jButtonGet.setEnabled(true);
                }
                jPanelActivation.setVisible(true);
                break;
            case PCAN_API_VERSION:
                // show the Version of the used API
                jButtonGet.setEnabled(true);
                break;
            case PCAN_CHANNEL_VERSION:
                // show the Version of th eused Channel
            case PCAN_CONTROLLER_NUMBER:
                // show the controller number
            case PCAN_RECEIVE_STATUS:
                // show the Receive Status
            case PCAN_HARDWARE_NAME:
                // show the real CAN Hardware name
                if (getSelectedConnectedChannel() != TPCANHandle.PCAN_NONEBUS)
                {
                    jButtonGet.setEnabled(true);
                }
                break;
            case PCAN_BUSOFF_AUTORESET:
               // parameter to set the CAN Controller in a AutiReset mode if run into BUSOFF (like a Watchdog)
                if (getSelectedConnectedChannel() != TPCANHandle.PCAN_NONEBUS)
                {
                    jButtonSet.setEnabled(true);
                    jButtonGet.setEnabled(true);
                }
                jPanelActivation.setVisible(true);
                break;
            case PCAN_LISTEN_ONLY:
                // Verify Channel contains SJA1000 microcontroller
                // and set the CAN Channel in passive mode !
                if (getSelectedConnectedChannel() != TPCANHandle.PCAN_NONEBUS)
                    // && TPCANHandle.containsSJA(getSelectedConnectedChannel(), getSelectedChannelItem().getType()))
                {
                    jButtonSet.setEnabled(true);
                    jButtonGet.setEnabled(true);
                }
                jPanelActivation.setVisible(true);
                break;
            case PCAN_LOG_LOCATION:
               // Path to the Logfile
                if (jTextAreaPath.getText().length() > 0)
                {
                    jButtonSet.setEnabled(true);
                }
                jButtonGet.setEnabled(true);
                jPanelLogPath.setVisible(true);
                break;
            case PCAN_LOG_STATUS:
                // Status of the Log function
                jButtonSet.setEnabled(true);
                jButtonGet.setEnabled(true);
                jPanelActivation.setVisible(true);
                break;
            case PCAN_LOG_CONFIGURE:
               // configure the LOG function
                jButtonSet.setEnabled(true);
                jButtonGet.setEnabled(true);
                jPanelLogConfigure.setVisible(true);
                break;
            case PCAN_CHANNEL_CONDITION:
               // show the condition of a CAN Channel                
                jButtonGet.setEnabled(true);
                break;
            case PCAN_TRACE_STATUS:
               // show if the Trace of a CAN Channel is on or not
                jButtonSet.setEnabled(true);
                jButtonGet.setEnabled(true);
                jPanelActivation.setVisible(true);
                break;                
            case PCAN_TRACE_LOCATION:
               // show /set Tracer directory
                if (jTextAreaPath.getText().length() > 0)
                {
                    jButtonSet.setEnabled(true);
                }
                jButtonGet.setEnabled(true);
                jPanelLogPath.setVisible(true);              
                break;
            case PCAN_TRACE_SIZE:
                // set the Tracer file size
                // if (jTextAreaPath.getText().length() > 0)
                {
                    jButtonSet.setEnabled(true);
                    jButtonGet.setEnabled(true);                    
                }
                jPanelTraceSize.setVisible(true);              
                break;
            case PCAN_TRACE_CONFIGURE:
                // set / get Tracer 
                jButtonSet.setEnabled(true);
                jButtonGet.setEnabled(true);
                jPanelTraceConfigure.setVisible(true);
                jCheckBoxSingle.setSelected(true);
                break;      
            case PCAN_CHANNEL_IDENTIFYING:
            case PCAN_BITRATE_ADAPTING:
                jButtonSet.setEnabled(true);
                jButtonGet.setEnabled(true);                
                jPanelActivation.setVisible(true);
                break;
            case PCAN_CHANNEL_FEATURES:
            case PCAN_BITRATE_INFO:
            case PCAN_BITRATE_INFO_FD:
            case PCAN_BUSSPEED_NOMINAL:
            case PCAN_BUSSPEED_DATA:
            case PCAN_IP_ADDRESS:
                jButtonGet.setEnabled(true);
                break;
        }
    }//GEN-LAST:event_jComboBoxParameterActionPerformed

    private void jButtonGetActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jButtonGetActionPerformed
    {//GEN-HEADEREND:event_jButtonGetActionPerformed
        // Prepare variables - GET - 
        TPCANStatus status = null;
        StringBuffer buffer = new StringBuffer(MAX_PATH);
        MutableInteger integerBuffer = new MutableInteger(0);
        String message = "";

        // Switch on selected Parameter
        switch ((TPCANParameter) jComboBoxParameter.getSelectedItem())
        {
            case PCAN_DEVICE_NUMBER:
            case PCAN_5VOLTS_POWER:
            case PCAN_BUSOFF_AUTORESET:
            case PCAN_LISTEN_ONLY:
            case PCAN_CONTROLLER_NUMBER: 
            case PCAN_RECEIVE_STATUS:
            case PCAN_TRACE_STATUS:                
            case PCAN_TRACE_SIZE:
            case PCAN_TRACE_CONFIGURE:   
            case PCAN_CHANNEL_IDENTIFYING:                              
            case PCAN_BITRATE_ADAPTING:                                
            case PCAN_BITRATE_INFO:                              
            case PCAN_CHANNEL_FEATURES:                           
            case PCAN_BUSSPEED_NOMINAL:                           
            case PCAN_BUSSPEED_DATA:                              
                // Retrieves information from a PCAN Channel in numeric form.
                status = pcanBasic.GetValue(getSelectedConnectedChannel(), (TPCANParameter) jComboBoxParameter.getSelectedItem(), integerBuffer, Integer.SIZE);
                break;
            case PCAN_HARDWARE_NAME:                 
            case PCAN_CHANNEL_VERSION:
            case PCAN_TRACE_LOCATION:                       
            case PCAN_BITRATE_INFO_FD:   
            case PCAN_IP_ADDRESS: 
                // Retrieves information from a PCAN Channel in text form.
                status = pcanBasic.GetValue(getSelectedConnectedChannel(), (TPCANParameter) jComboBoxParameter.getSelectedItem(), buffer, buffer.capacity());
                break;
            case PCAN_API_VERSION:
            case PCAN_LOG_LOCATION:
                // Retrieves information from a PCAN Channel in text form.
                status = pcanBasic.GetValue(TPCANHandle.PCAN_NONEBUS, (TPCANParameter) jComboBoxParameter.getSelectedItem(), buffer, buffer.capacity());
                break;
            case PCAN_LOG_CONFIGURE:
            case PCAN_LOG_STATUS:
                // Retrieves information from a PCAN Channel in numeric form using Default channel Only.
                status = pcanBasic.GetValue(TPCANHandle.PCAN_NONEBUS, (TPCANParameter) jComboBoxParameter.getSelectedItem(), integerBuffer, Integer.SIZE);
                break;
            case PCAN_CHANNEL_CONDITION:
                // Retrieves information from a PCAN Channel in numeric form using non initialized channel.
                status = pcanBasic.GetValue(getSelectedChannel(), (TPCANParameter) jComboBoxParameter.getSelectedItem(), integerBuffer, Integer.SIZE);
                break;
        }

        // Process Result
        if (status == TPCANStatus.PCAN_ERROR_OK)
        {
            switch ((TPCANParameter) jComboBoxParameter.getSelectedItem())
            {
                case PCAN_DEVICE_NUMBER:
                    showInfo("USB Device Number is: " + integerBuffer, false);
                    break;
                case PCAN_5VOLTS_POWER:
                    showInfo("The external 5V is: " + TPCANParameterValue.parseOnOff(integerBuffer.getValue()), false);
                    break;
                case PCAN_API_VERSION:
                    showInfo("The PCAN-Basic API implementation version is: " + buffer, false);
                    break;
                case PCAN_CHANNEL_VERSION:
                    showInfo("The Driver of " + getSelectedConnectedChannel() + " is: " + buffer, false);
                    break;
                case PCAN_BUSOFF_AUTORESET:
                    showInfo("The PCAN_BUSOFF_AUTORESET parameter is: " + TPCANParameterValue.parseOnOff(integerBuffer.getValue()), false);
                    break;
                case PCAN_LISTEN_ONLY:
                    showInfo("The PCAN_LISTEN_ONLY parameter is: " + TPCANParameterValue.parseOnOff(integerBuffer.getValue()), false);
                    break;
                case PCAN_LOG_LOCATION:
                    showInfo("The Log File Path is: " + buffer, false);
                    break;
                case PCAN_LOG_STATUS:
                    showInfo("The PCAN_LOG_STATUS parameter is: " + TPCANParameterValue.parseOnOff(integerBuffer.getValue()), false);
                    break;
                case PCAN_LOG_CONFIGURE:
                    message = "Debug informations include:";
                    // Process included information in Log using Parameter values
                    if ((integerBuffer.getValue() & TPCANParameterValue.LOG_FUNCTION_ENTRY.getValue()) == TPCANParameterValue.LOG_FUNCTION_ENTRY.getValue())
                    {
                        message += "\nLOG_FUNCTION_ENTRY";
                    }
                    if ((integerBuffer.getValue() & TPCANParameterValue.LOG_FUNCTION_LEAVE.getValue()) == TPCANParameterValue.LOG_FUNCTION_LEAVE.getValue())
                    {
                        message += "\nLOG_FUNCTION_LEAVE";
                    }
                    if ((integerBuffer.getValue() & TPCANParameterValue.LOG_FUNCTION_PARAMETERS.getValue()) == TPCANParameterValue.LOG_FUNCTION_PARAMETERS.getValue())
                    {
                        message += "\nLOG_FUNCTION_PARAMETERS";
                    }
                    if ((integerBuffer.getValue() & TPCANParameterValue.LOG_FUNCTION_READ.getValue()) == TPCANParameterValue.LOG_FUNCTION_READ.getValue())
                    {
                        message += "\nLOG_FUNCTION_READ";
                    }
                    if ((integerBuffer.getValue() & TPCANParameterValue.LOG_FUNCTION_WRITE.getValue()) == TPCANParameterValue.LOG_FUNCTION_WRITE.getValue())
                    {
                        message += "\nLOG_FUNCTION_WRITE";
                    }
                    if (integerBuffer.value == 0)
                    {
                        message += "\nLOG_FUNCTION_DEFAULT";
                    }
                    showInfo(message, false);
                    break;
                case PCAN_CHANNEL_CONDITION:
                    showInfo("The PCAN_CHANNEL_CONDITION parameter is: " + TPCANParameterValue.parseCondition(integerBuffer.getValue()), false);
                    break;
                case PCAN_RECEIVE_STATUS:
                    showInfo("The PCAN_RECEIVE_STATUS parameter is: " + TPCANParameterValue.parseOnOff(integerBuffer.getValue()), false);
                    break;                    
                case PCAN_CONTROLLER_NUMBER:
                    showInfo("The PCAN_CONTROLLER_NUMBER parameter is: "  + integerBuffer, false);
                    break;     
                case PCAN_HARDWARE_NAME:
                    showInfo("The Hardware Name is: " + buffer, false);
                    break;
                case PCAN_TRACE_LOCATION:
                    showInfo("The Trace File Path is: " + buffer, false);
                    break;
                case PCAN_TRACE_STATUS:
                    showInfo("The PCAN_TRACE_STATUS parameter is: " + TPCANParameterValue.parseOnOff(integerBuffer.getValue()), false);
                    break;                    
                case PCAN_TRACE_SIZE:
                    showInfo("The Tracer Size is: " + integerBuffer + " MByte", false);
                    break;           
               case PCAN_TRACE_CONFIGURE:
                    message = "Debug informations include:";
                    // Process included information in Log using Parameter values

                    if ((integerBuffer.getValue() & TPCANParameterValue.TRACE_FILE_SEGMENTED.getValue()) == TPCANParameterValue.TRACE_FILE_SEGMENTED.getValue())
                    {
                        message += "\nTRACE_FILE_SEGMENTED";
                    }else
                    {
                        message += "\nTRACE_FILE_SINGLE";
                    }                        
                    if ((integerBuffer.getValue() & TPCANParameterValue.TRACE_FILE_DATE.getValue()) == TPCANParameterValue.TRACE_FILE_DATE.getValue())
                    {
                        message += "\nTRACE_FILE_DATE";
                    }
                    if ((integerBuffer.getValue() & TPCANParameterValue.TRACE_FILE_TIME.getValue()) == TPCANParameterValue.TRACE_FILE_TIME.getValue())
                    {
                        message += "\nTRACE_FILE_TIME";
                    }
                    if ((integerBuffer.getValue() & TPCANParameterValue.TRACE_FILE_OVERWRITE.getValue()) == TPCANParameterValue.TRACE_FILE_OVERWRITE.getValue())
                    {
                        message += "\nTRACE_FILE_OVERWRITE";
                    }                    
                    if (integerBuffer.value == 0)
                    {
                        message += "\nLOG_FUNCTION_DEFAULT";
                    }
                    showInfo(message, false);
                    break; 
                case PCAN_CHANNEL_IDENTIFYING:                        
                    showInfo("The PCAN_CHANNEL_IDENTIFYING parameter is: " + integerBuffer, false);  
                    break;                                              
                case PCAN_BITRATE_ADAPTING:        
                    showInfo("The PCAN_BITRATE_ADAPTING parameter is: " + TPCANParameterValue.parseOnOff(integerBuffer.getValue()), false);   
                    break;                                           
                case PCAN_BITRATE_INFO:    
                    message = integerBuffer.toString();
                    for (TPCANBaudrate br : TPCANBaudrate.values())
                        if (br.getValue() == integerBuffer.getValue())
                            message = br.toString();
                    showInfo("The PCAN_BITRATE_INFO parameter is: " + message, false);                    
                    break;                      
                case PCAN_BITRATE_INFO_FD:
                    showInfo("The PCAN_BITRATE_INFO_FD parameter is: " + buffer, false);
                    break;                           
                case PCAN_CHANNEL_FEATURES:
                    showInfo("The PCAN_CHANNEL_FEATURES parameter is: " + integerBuffer, false);
                    break;                       
                case PCAN_BUSSPEED_NOMINAL:
                    showInfo("The PCAN_BUSSPEED_NOMINAL parameter is: " + integerBuffer + " Bits/sec", false);
                    break;                   
                case PCAN_BUSSPEED_DATA:
                    showInfo("The PCAN_BUSSPEED_DATA parameter is: " + integerBuffer + " Bits/sec", false);
                    break;                    
                case PCAN_IP_ADDRESS:
                    showInfo("The PCAN_IP_ADDRESS parameter is: " + buffer, false);
                    break;
            }
        }
        else
        {
            getError(status);     // Process Error
        }
    }//GEN-LAST:event_jButtonGetActionPerformed

    private void jButtonSetActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jButtonSetActionPerformed
    {//GEN-HEADEREND:event_jButtonSetActionPerformed
        // Prepare variables - SET - 
        TPCANStatus status;
        StringBuffer buffer = new StringBuffer(MAX_PATH);
        MutableInteger integerBuffer = new MutableInteger(0);
        String message;
        
        status = TPCANStatus.PCAN_ERROR_UNKNOWN;
        // Switch on selected Parameter
        switch ((TPCANParameter) jComboBoxParameter.getSelectedItem())
        {
            case PCAN_DEVICE_NUMBER:
                // Gets selected device number in parameter
                integerBuffer = new MutableInteger(jSpinnerDeviceNumber.getValue().toString());
                // Sets a configuration or information numeric value within a PCAN Channel.
                status = pcanBasic.SetValue(getSelectedConnectedChannel(), (TPCANParameter) jComboBoxParameter.getSelectedItem(), integerBuffer, Integer.SIZE);
                break;
            case PCAN_5VOLTS_POWER:
            case PCAN_BUSOFF_AUTORESET:
            case PCAN_LISTEN_ONLY:
            case PCAN_CHANNEL_CONDITION:
            case PCAN_RECEIVE_STATUS:
            case PCAN_CHANNEL_IDENTIFYING:
            case PCAN_BITRATE_ADAPTING:
                 // Gets selected activation value(ON||OFF) in paramater
                integerBuffer = new MutableInteger(getSelectedActivationValue().getValue());
                // Sets a configuration or information numeric value within a PCAN Channel.
                status = pcanBasic.SetValue(getSelectedConnectedChannel(), (TPCANParameter) jComboBoxParameter.getSelectedItem(), integerBuffer, Integer.SIZE);
                break;
            case PCAN_LOG_LOCATION:
                // Gets File Path Location in StringBuffer
                buffer.append(jTextAreaPath.getText());
                // Sets a configuration or information string value within a PCAN Channel.
                status = pcanBasic.SetValue(TPCANHandle.PCAN_NONEBUS, (TPCANParameter) jComboBoxParameter.getSelectedItem(), buffer, buffer.length());
                break;
                
            case PCAN_TRACE_LOCATION:
                // Gets File Path Location in StringBuffer
                buffer.append(jTextAreaPath.getText());
                // Sets a configuration or information string value within a PCAN Channel.
                status = pcanBasic.SetValue(getSelectedConnectedChannel(), (TPCANParameter) jComboBoxParameter.getSelectedItem(), buffer, buffer.length());
                break;  
                
            case PCAN_LOG_STATUS:
                // Gets selected activation value(ON||OFF) in paramater
                integerBuffer = new MutableInteger(getSelectedActivationValue().getValue());
                // Sets a configuration or information numeric value within the Default channel.
                status = pcanBasic.SetValue(TPCANHandle.PCAN_NONEBUS, (TPCANParameter) jComboBoxParameter.getSelectedItem(), integerBuffer, Integer.SIZE);
                break;
                
            case PCAN_TRACE_STATUS:
                // Gets selected activation value(ON||OFF) in paramater
                integerBuffer = new MutableInteger(getSelectedActivationValue().getValue());
                // Sets a configuration or information numeric value within the Default channel.
                status = pcanBasic.SetValue(getSelectedConnectedChannel(), (TPCANParameter) jComboBoxParameter.getSelectedItem(), integerBuffer, Integer.SIZE);
                break;    
                
            case PCAN_LOG_CONFIGURE:
                // Prepares selected log information type in the parameter
                if (jCheckBoxEntry.isSelected())
                {
                    integerBuffer.value = integerBuffer.value | TPCANParameterValue.LOG_FUNCTION_ENTRY.getValue();
                }
                if (jCheckBoxLeave.isSelected())
                {
                    integerBuffer.value = integerBuffer.value | TPCANParameterValue.LOG_FUNCTION_LEAVE.getValue();
                }
                if (jCheckBoxParameter.isSelected())
                {
                    integerBuffer.value = integerBuffer.value | TPCANParameterValue.LOG_FUNCTION_PARAMETERS.getValue();
                }
                if (jCheckBoxRead.isSelected())
                {
                    integerBuffer.value = integerBuffer.value | TPCANParameterValue.LOG_FUNCTION_READ.getValue();
                }
                if (jCheckBoxWrite.isSelected())
                {
                    integerBuffer.value = integerBuffer.value | TPCANParameterValue.LOG_FUNCTION_WRITE.getValue();
                }
                status = pcanBasic.SetValue(TPCANHandle.PCAN_NONEBUS, (TPCANParameter) jComboBoxParameter.getSelectedItem(), integerBuffer, Integer.SIZE);
                break;
                
            case PCAN_TRACE_SIZE:        
                // Gets selected device number in parameter
                integerBuffer = new MutableInteger(jSpinnerTraceSize.getValue().toString());
                // Sets a configuration or information numeric value within a PCAN Channel.
                status = pcanBasic.SetValue(getSelectedConnectedChannel(), (TPCANParameter) jComboBoxParameter.getSelectedItem(), integerBuffer, Integer.SIZE);                
                break;

            case PCAN_TRACE_CONFIGURE:
                // Prepares selected log information type in the parameter
                if (jCheckBoxSingle.isSelected())
                {
                    integerBuffer.value = integerBuffer.value | TPCANParameterValue.TRACE_FILE_SINGLE.getValue();
                }
                if (jCheckBoxSegmented.isSelected())
                {
                    integerBuffer.value = integerBuffer.value | TPCANParameterValue.TRACE_FILE_SEGMENTED.getValue();
                }
                if (jCheckBoxDate.isSelected())
                {
                    integerBuffer.value = integerBuffer.value | TPCANParameterValue.TRACE_FILE_DATE.getValue();
                }
                if (jCheckBoxTime.isSelected())
                {
                    integerBuffer.value = integerBuffer.value | TPCANParameterValue.TRACE_FILE_TIME.getValue();
                }
                if (jCheckBoxOverwrite.isSelected())
                {
                    integerBuffer.value = integerBuffer.value | TPCANParameterValue.TRACE_FILE_OVERWRITE.getValue();
                }
                status = pcanBasic.SetValue(getSelectedConnectedChannel(), (TPCANParameter) jComboBoxParameter.getSelectedItem(), integerBuffer, Integer.SIZE);
                break;                
        }

        // Process Result
        if (status == TPCANStatus.PCAN_ERROR_OK)
        {
            switch ((TPCANParameter) jComboBoxParameter.getSelectedItem())
            {
                case PCAN_DEVICE_NUMBER:
                    showInfo("USB Device Number was successfully changed to: " + integerBuffer, false);
                    break;
                case PCAN_5VOLTS_POWER:
                    showInfo("The external 5V was successfully configured to: " + getSelectedActivationValue(), false);
                    break;
                case PCAN_BUSOFF_AUTORESET:
                    showInfo("The PCAN_BUSOFF_AUTORESET parameter was successfully configured to: " + getSelectedActivationValue(), false);
                    break;
                case PCAN_LISTEN_ONLY:
                    showInfo("The PCAN_LISTEN_ONLY parameter was successfully configured to: " + getSelectedActivationValue(), false);
                    break;
                case PCAN_LOG_LOCATION:
                    showInfo("The Log File Path  was successfully configured to: " + buffer, false);
                    break;
                case PCAN_LOG_STATUS:
                    showInfo("The PCAN_LOG_STATUS parameter was successfully configured to: " + getSelectedActivationValue(), false);
                    break;
                case PCAN_LOG_CONFIGURE:
                    message = "Now, debug informations will include:";
                    if ((integerBuffer.getValue() & TPCANParameterValue.LOG_FUNCTION_ENTRY.getValue()) == TPCANParameterValue.LOG_FUNCTION_ENTRY.getValue())
                    {
                        message += "\nLOG_FUNCTION_ENTRY";
                    }
                    if ((integerBuffer.getValue() & TPCANParameterValue.LOG_FUNCTION_LEAVE.getValue()) == TPCANParameterValue.LOG_FUNCTION_LEAVE.getValue())
                    {
                        message += "\nLOG_FUNCTION_LEAVE";
                    }
                    if ((integerBuffer.getValue() & TPCANParameterValue.LOG_FUNCTION_PARAMETERS.getValue()) == TPCANParameterValue.LOG_FUNCTION_PARAMETERS.getValue())
                    {
                        message += "\nLOG_FUNCTION_PARAMETERS";
                    }
                    if ((integerBuffer.getValue() & TPCANParameterValue.LOG_FUNCTION_READ.getValue()) == TPCANParameterValue.LOG_FUNCTION_READ.getValue())
                    {
                        message += "\nLOG_FUNCTION_READ";
                    }
                    if ((integerBuffer.getValue() & TPCANParameterValue.LOG_FUNCTION_WRITE.getValue()) == TPCANParameterValue.LOG_FUNCTION_WRITE.getValue())
                    {
                        message += "\nLOG_FUNCTION_WRITE";
                    }
                    if (integerBuffer.value == 0)
                    {
                        message += "\nLOG_FUNCTION_DEFAULT";
                    }
                    showInfo(message, false);
                    break;
                case PCAN_TRACE_STATUS:
                    showInfo("The PCAN_TRACE_STATUS parameter was successfully configured to: " + getSelectedActivationValue(), false);
                    break;                    
                case PCAN_TRACE_LOCATION:
                    showInfo("The Trace File Path  was successfully configured to: " + buffer, false);
                    break;                    
                case PCAN_TRACE_SIZE:
                    showInfo("The Tracer Size was successfully configured to: " + integerBuffer, false);
                    break;               
               case PCAN_TRACE_CONFIGURE:
                    message = "Now, the Trace was configered::";
                    if ((integerBuffer.getValue() & TPCANParameterValue.TRACE_FILE_SEGMENTED.getValue()) == TPCANParameterValue.TRACE_FILE_SEGMENTED.getValue())
                    {
                        message += "\nTRACE_FILE_SEGMENTED";
                    }else
                    {
                        message += "\nTRACE_FILE_SINGLE";
                    }                        
                    if ((integerBuffer.getValue() & TPCANParameterValue.TRACE_FILE_DATE.getValue()) == TPCANParameterValue.TRACE_FILE_DATE.getValue())
                    {
                        message += "\nTRACE_FILE_DATE";
                    }
                    if ((integerBuffer.getValue() & TPCANParameterValue.TRACE_FILE_TIME.getValue()) == TPCANParameterValue.TRACE_FILE_TIME.getValue())
                    {
                        message += "\nTRACE_FILE_TIME";
                    }
                    if ((integerBuffer.getValue() & TPCANParameterValue.TRACE_FILE_OVERWRITE .getValue()) == TPCANParameterValue.TRACE_FILE_OVERWRITE .getValue())
                    {
                        message += "\nTRACE_FILE_OVERWRITE ";
                    }
                    if (integerBuffer.value == 0)
                    {
                        message += "\nTRACE_FILE_DEFAULT";
                    }
                    showInfo(message, false);
                    break;                   
               case PCAN_CHANNEL_IDENTIFYING:
                    showInfo("The Identification process was successfully configured to: " + getSelectedActivationValue(), false);
                    break;                   
               case PCAN_BITRATE_ADAPTING:
                    showInfo("PCAN_BITRATE_ADAPTING was successfully configured to: " + getSelectedActivationValue(), false);
                    break;     
            }
        }
        else
        {
            getError(status);   // Process Error
        }
    }//GEN-LAST:event_jButtonSetActionPerformed

    private void jTextFieldWriteIDFocusLost(java.awt.event.FocusEvent evt)//GEN-FIRST:event_jTextFieldWriteIDFocusLost
    {//GEN-HEADEREND:event_jTextFieldWriteIDFocusLost
        checkMessageID((JTextField) evt.getComponent(), jCheckBoxWriteExtended.isSelected());
}//GEN-LAST:event_jTextFieldWriteIDFocusLost

    private void jTextFieldWriteIDKeyTyped(java.awt.event.KeyEvent evt)//GEN-FIRST:event_jTextFieldWriteIDKeyTyped
    {//GEN-HEADEREND:event_jTextFieldWriteIDKeyTyped
        checkHex(evt);
}//GEN-LAST:event_jTextFieldWriteIDKeyTyped

    private void jSpinnerLengthStateChanged(javax.swing.event.ChangeEvent evt)//GEN-FIRST:event_jSpinnerLengthStateChanged
    {//GEN-HEADEREND:event_jSpinnerLengthStateChanged
        int selectedLength;
        boolean value;
        selectedLength = (Integer) jSpinnerLength.getValue() - 1;

        // Enable or disable txtData regarding selected length
        jTextFieldData0.setEnabled((selectedLength >= 0) ? true : false);
        jTextFieldData1.setEnabled((selectedLength >= 1) ? true : false);
        jTextFieldData2.setEnabled((selectedLength >= 2) ? true : false);
        jTextFieldData3.setEnabled((selectedLength >= 3) ? true : false);
        jTextFieldData4.setEnabled((selectedLength >= 4) ? true : false);
        jTextFieldData5.setEnabled((selectedLength >= 5) ? true : false);
        jTextFieldData6.setEnabled((selectedLength >= 6) ? true : false);
        jTextFieldData7.setEnabled((selectedLength >= 7) ? true : false);
        // FD: DLC 9 => 12bytes
        value = (selectedLength >= 8) ? true : false;
        jTextFieldData8.setEnabled(value);
        jTextFieldData9.setEnabled(value);
        jTextFieldData10.setEnabled(value);
        jTextFieldData11.setEnabled(value);
        // FD: DLC 10 => 16bytes
        value = (selectedLength >= 9) ? true : false;
        jTextFieldData12.setEnabled(value);
        jTextFieldData13.setEnabled(value);
        jTextFieldData14.setEnabled(value);
        jTextFieldData15.setEnabled(value);
        // FD: DLC 11 => 20bytes
        value = (selectedLength >= 10) ? true : false;
        jTextFieldData16.setEnabled(value);
        jTextFieldData17.setEnabled(value);
        jTextFieldData18.setEnabled(value);
        jTextFieldData19.setEnabled(value);
        // FD: DLC 12 => 24bytes
        value = (selectedLength >= 11) ? true : false;
        jTextFieldData20.setEnabled(value);
        jTextFieldData21.setEnabled(value);
        jTextFieldData22.setEnabled(value);
        jTextFieldData23.setEnabled(value);
        // FD: DLC 13 => 32bytes
        value = (selectedLength >= 12) ? true : false;
        jTextFieldData24.setEnabled(value);
        jTextFieldData25.setEnabled(value);
        jTextFieldData26.setEnabled(value);
        jTextFieldData27.setEnabled(value);
        jTextFieldData28.setEnabled(value);
        jTextFieldData29.setEnabled(value);
        jTextFieldData30.setEnabled(value);
        jTextFieldData31.setEnabled(value);
        // FD: DLC 14 => 48bytes
        value = (selectedLength >= 13) ? true : false;
        jTextFieldData32.setEnabled(value);
        jTextFieldData33.setEnabled(value);
        jTextFieldData34.setEnabled(value);
        jTextFieldData35.setEnabled(value);
        jTextFieldData36.setEnabled(value);
        jTextFieldData37.setEnabled(value);
        jTextFieldData38.setEnabled(value);
        jTextFieldData39.setEnabled(value);
        jTextFieldData40.setEnabled(value);
        jTextFieldData41.setEnabled(value);
        jTextFieldData42.setEnabled(value);
        jTextFieldData43.setEnabled(value);
        jTextFieldData44.setEnabled(value);
        jTextFieldData45.setEnabled(value);
        jTextFieldData46.setEnabled(value);
        jTextFieldData47.setEnabled(value);
        // FD: DLC 15 => 64bytes
        value = (selectedLength >= 14) ? true : false;
        jTextFieldData48.setEnabled(value);
        jTextFieldData49.setEnabled(value);
        jTextFieldData50.setEnabled(value);
        jTextFieldData51.setEnabled(value);
        jTextFieldData52.setEnabled(value);
        jTextFieldData53.setEnabled(value);
        jTextFieldData54.setEnabled(value);
        jTextFieldData55.setEnabled(value);
        jTextFieldData56.setEnabled(value);
        jTextFieldData57.setEnabled(value);
        jTextFieldData58.setEnabled(value);
        jTextFieldData59.setEnabled(value);
        jTextFieldData60.setEnabled(value);
        jTextFieldData61.setEnabled(value);
        jTextFieldData62.setEnabled(value);
        jTextFieldData63.setEnabled(value);
}//GEN-LAST:event_jSpinnerLengthStateChanged

    private void jTextFieldDataFocusLost(java.awt.event.FocusEvent evt)//GEN-FIRST:event_jTextFieldDataFocusLost
    {//GEN-HEADEREND:event_jTextFieldDataFocusLost
        checkDataBox((JTextField) evt.getComponent());
}//GEN-LAST:event_jTextFieldDataFocusLost

    private void jTextFieldDataKeyTyped(java.awt.event.KeyEvent evt)//GEN-FIRST:event_jTextFieldDataKeyTyped
    {//GEN-HEADEREND:event_jTextFieldDataKeyTyped
        checkHex(evt);
}//GEN-LAST:event_jTextFieldDataKeyTyped

    private void jButtonWriteActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jButtonWriteActionPerformed
    {//GEN-HEADEREND:event_jButtonWriteActionPerformed
        TPCANStatus status = null;
        
        if (!jCheckBoxWriteFd.isSelected()) {
            TPCANMsg msgToSend;
            int type = 0;

            // We create a TCLightMsg message structure
            msgToSend = new TPCANMsg();

            // We configurate the Message.  The ID (max 0x1FF),
            // Length of the Data, Message Type (Standard in
            // this example) and die data
            msgToSend.setID((int) hexTextToInt(jTextFieldWriteID.getText()));
            msgToSend.setLength(Byte.parseByte(jSpinnerLength.getValue().toString()));
            msgToSend.setType((jCheckBoxWriteExtended.isSelected()) ? TPCANMsg.MSGTYPE_EXTENDED : TPCANMsg.MSGTYPE_STANDARD);

            // If a remote frame will be sent, the data bytes are not important.
            if (jCheckBoxWriteRemote.isSelected())
            {
                type = msgToSend.getType() | TPCANMsg.MSGTYPE_RTR;
                msgToSend.setType((byte) type);
            }
            else
            {
                // We get so much data as the Len of the message
                if (msgToSend.getLength() >= 1)
                {
                    msgToSend.getData()[0] = (byte) hexTextToInt(jTextFieldData0.getText());
                }
                if (msgToSend.getLength() >= 2)
                {                
                    msgToSend.getData()[1] = (byte) hexTextToInt(jTextFieldData1.getText());
                }                
                if (msgToSend.getLength() >= 3)
                {                
                    msgToSend.getData()[2] = (byte) hexTextToInt(jTextFieldData2.getText());
                }                
                if (msgToSend.getLength() >= 4)
                {                
                    msgToSend.getData()[3] = (byte) hexTextToInt(jTextFieldData3.getText());
                }
                if (msgToSend.getLength() >= 5)
                {                
                    msgToSend.getData()[4] = (byte) hexTextToInt(jTextFieldData4.getText());
                }                
                if (msgToSend.getLength() >= 6)
                {                
                    msgToSend.getData()[5] = (byte) hexTextToInt(jTextFieldData5.getText());
                }                
                if (msgToSend.getLength() >= 7)
                {                
                    msgToSend.getData()[6] = (byte) hexTextToInt(jTextFieldData6.getText());
                }                
                if (msgToSend.getLength() >= 8)
                {                
                    msgToSend.getData()[7] = (byte) hexTextToInt(jTextFieldData7.getText());
                }                
            }

            // The message is sent to the configured hardware
            status = pcanBasic.Write(getSelectedConnectedChannel(), msgToSend);
        } else {
            TPCANMsgFD msgToSend;
            EnumSet<TPCANMessageType> enumType = EnumSet.noneOf(TPCANMessageType.class);

            // We create a TCLightMsg message structure
            msgToSend = new TPCANMsgFD();

            // We configurate the Message.  The ID (max 0x1FF),
            // Length of the Data, Message Type (Standard in
            // this example) and die data
            msgToSend.setID((int) hexTextToInt(jTextFieldWriteID.getText()));
            msgToSend.setDlc(Byte.parseByte(jSpinnerLength.getValue().toString()));
            if (jCheckBoxWriteExtended.isSelected())
                enumType.add(TPCANMessageType.PCAN_MESSAGE_EXTENDED);
            else 
                enumType.add(TPCANMessageType.PCAN_MESSAGE_STANDARD);
            if (jCheckBoxWriteFd.isSelected())
                enumType.add(TPCANMessageType.PCAN_MESSAGE_FD);
            if (jCheckBoxWriteBrs.isSelected())
                enumType.add(TPCANMessageType.PCAN_MESSAGE_BRS);                        
            msgToSend.setType(enumType);

            // We get so much data as the Len of the message
            if (msgToSend.getDlc() >= 1)
            {
                msgToSend.getData()[0] = (byte) hexTextToInt(jTextFieldData0.getText());
            }
            if (msgToSend.getDlc() >= 2)
            {                
                msgToSend.getData()[1] = (byte) hexTextToInt(jTextFieldData1.getText());
            }                
            if (msgToSend.getDlc() >= 3)
            {                
                msgToSend.getData()[2] = (byte) hexTextToInt(jTextFieldData2.getText());
            }                
            if (msgToSend.getDlc() >= 4)
            {                
                msgToSend.getData()[3] = (byte) hexTextToInt(jTextFieldData3.getText());
            }
            if (msgToSend.getDlc() >= 5)
            {                
                msgToSend.getData()[4] = (byte) hexTextToInt(jTextFieldData4.getText());
            }                
            if (msgToSend.getDlc() >= 6)
            {                
                msgToSend.getData()[5] = (byte) hexTextToInt(jTextFieldData5.getText());
            }                
            if (msgToSend.getDlc() >= 7)
            {                
                msgToSend.getData()[6] = (byte) hexTextToInt(jTextFieldData6.getText());
            }                
            if (msgToSend.getDlc() >= 8)
            {                
                msgToSend.getData()[7] = (byte) hexTextToInt(jTextFieldData7.getText());
            }                
            if (msgToSend.getDlc() >= 9)
            {                
                msgToSend.getData()[8] = (byte) hexTextToInt(jTextFieldData8.getText());
                msgToSend.getData()[9] = (byte) hexTextToInt(jTextFieldData9.getText());
                msgToSend.getData()[10] = (byte) hexTextToInt(jTextFieldData10.getText());
                msgToSend.getData()[11] = (byte) hexTextToInt(jTextFieldData11.getText());
            }                
            if (msgToSend.getDlc() >= 10)
            {                
                msgToSend.getData()[12] = (byte) hexTextToInt(jTextFieldData12.getText());
                msgToSend.getData()[13] = (byte) hexTextToInt(jTextFieldData13.getText());
                msgToSend.getData()[14] = (byte) hexTextToInt(jTextFieldData14.getText());
                msgToSend.getData()[15] = (byte) hexTextToInt(jTextFieldData15.getText());
            }               
            if (msgToSend.getDlc() >= 11)
            {                
                msgToSend.getData()[16] = (byte) hexTextToInt(jTextFieldData16.getText());
                msgToSend.getData()[17] = (byte) hexTextToInt(jTextFieldData17.getText());
                msgToSend.getData()[18] = (byte) hexTextToInt(jTextFieldData18.getText());
                msgToSend.getData()[19] = (byte) hexTextToInt(jTextFieldData19.getText());
            }               
            if (msgToSend.getDlc() >= 12)
            {                
                msgToSend.getData()[20] = (byte) hexTextToInt(jTextFieldData20.getText());
                msgToSend.getData()[21] = (byte) hexTextToInt(jTextFieldData21.getText());
                msgToSend.getData()[22] = (byte) hexTextToInt(jTextFieldData22.getText());
                msgToSend.getData()[23] = (byte) hexTextToInt(jTextFieldData23.getText());
            }               
            if (msgToSend.getDlc() >= 13)
            {                
                msgToSend.getData()[24] = (byte) hexTextToInt(jTextFieldData24.getText());
                msgToSend.getData()[25] = (byte) hexTextToInt(jTextFieldData25.getText());
                msgToSend.getData()[26] = (byte) hexTextToInt(jTextFieldData26.getText());
                msgToSend.getData()[27] = (byte) hexTextToInt(jTextFieldData27.getText());
                msgToSend.getData()[28] = (byte) hexTextToInt(jTextFieldData28.getText());
                msgToSend.getData()[29] = (byte) hexTextToInt(jTextFieldData29.getText());
                msgToSend.getData()[30] = (byte) hexTextToInt(jTextFieldData30.getText());
                msgToSend.getData()[31] = (byte) hexTextToInt(jTextFieldData31.getText());
            }               
            if (msgToSend.getDlc() >= 14)
            {                
                msgToSend.getData()[32] = (byte) hexTextToInt(jTextFieldData32.getText());
                msgToSend.getData()[33] = (byte) hexTextToInt(jTextFieldData33.getText());
                msgToSend.getData()[34] = (byte) hexTextToInt(jTextFieldData34.getText());
                msgToSend.getData()[35] = (byte) hexTextToInt(jTextFieldData35.getText());
                msgToSend.getData()[36] = (byte) hexTextToInt(jTextFieldData36.getText());
                msgToSend.getData()[37] = (byte) hexTextToInt(jTextFieldData37.getText());
                msgToSend.getData()[38] = (byte) hexTextToInt(jTextFieldData38.getText());
                msgToSend.getData()[39] = (byte) hexTextToInt(jTextFieldData39.getText());
                msgToSend.getData()[40] = (byte) hexTextToInt(jTextFieldData40.getText());
                msgToSend.getData()[41] = (byte) hexTextToInt(jTextFieldData41.getText());
                msgToSend.getData()[42] = (byte) hexTextToInt(jTextFieldData42.getText());
                msgToSend.getData()[43] = (byte) hexTextToInt(jTextFieldData43.getText());
                msgToSend.getData()[44] = (byte) hexTextToInt(jTextFieldData44.getText());
                msgToSend.getData()[45] = (byte) hexTextToInt(jTextFieldData45.getText());
                msgToSend.getData()[46] = (byte) hexTextToInt(jTextFieldData46.getText());
                msgToSend.getData()[47] = (byte) hexTextToInt(jTextFieldData47.getText());
            }                
            if (msgToSend.getDlc() >= 15)
            {                
                msgToSend.getData()[48] = (byte) hexTextToInt(jTextFieldData48.getText());
                msgToSend.getData()[49] = (byte) hexTextToInt(jTextFieldData49.getText());
                msgToSend.getData()[50] = (byte) hexTextToInt(jTextFieldData50.getText());
                msgToSend.getData()[51] = (byte) hexTextToInt(jTextFieldData51.getText());
                msgToSend.getData()[52] = (byte) hexTextToInt(jTextFieldData52.getText());
                msgToSend.getData()[53] = (byte) hexTextToInt(jTextFieldData53.getText());
                msgToSend.getData()[54] = (byte) hexTextToInt(jTextFieldData54.getText());
                msgToSend.getData()[55] = (byte) hexTextToInt(jTextFieldData55.getText());
                msgToSend.getData()[56] = (byte) hexTextToInt(jTextFieldData56.getText());
                msgToSend.getData()[57] = (byte) hexTextToInt(jTextFieldData57.getText());
                msgToSend.getData()[58] = (byte) hexTextToInt(jTextFieldData58.getText());
                msgToSend.getData()[59] = (byte) hexTextToInt(jTextFieldData59.getText());
                msgToSend.getData()[60] = (byte) hexTextToInt(jTextFieldData60.getText());
                msgToSend.getData()[61] = (byte) hexTextToInt(jTextFieldData61.getText());
                msgToSend.getData()[62] = (byte) hexTextToInt(jTextFieldData62.getText());
                msgToSend.getData()[63] = (byte) hexTextToInt(jTextFieldData63.getText());                
            }         
            
            // The message is sent to the configured hardware
            status = pcanBasic.WriteFD(getSelectedConnectedChannel(), msgToSend);            
        }
            

        // The Hardware was successfully sent
        if (status == TPCANStatus.PCAN_ERROR_OK)
        {
                showInfo("Message was successfully SENT", false);
        // An error occurred.  We show the error.
        }
        else
        {
            getError(status);
        }
}//GEN-LAST:event_jButtonWriteActionPerformed

    private void jCheckBoxWriteExtendedActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jCheckBoxWriteExtendedActionPerformed
    {//GEN-HEADEREND:event_jCheckBoxWriteExtendedActionPerformed
        checkMessageID(jTextFieldWriteID, jCheckBoxWriteExtended.isSelected());
}//GEN-LAST:event_jCheckBoxWriteExtendedActionPerformed

    private void jCheckBoxWriteRemoteActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jCheckBoxWriteRemoteActionPerformed
    {//GEN-HEADEREND:event_jCheckBoxWriteRemoteActionPerformed
        boolean useTxtData = !jCheckBoxWriteRemote.isSelected();

        //Show or hide txtData depending it's a remote message        
        for (Component comp : jPanelWriteData.getComponents())
        {
            if (comp instanceof JTextField)
                comp.setVisible(useTxtData);            
        }
        jCheckBoxWriteFd.setEnabled(!jCheckBoxWriteRemote.isSelected());
}//GEN-LAST:event_jCheckBoxWriteRemoteActionPerformed

    private void jTextFieldIDFromFocusLost(java.awt.event.FocusEvent evt)//GEN-FIRST:event_jTextFieldIDFromFocusLost
    {//GEN-HEADEREND:event_jTextFieldIDFromFocusLost
        checkMessageID((JTextField) evt.getComponent(), jCheckBoxFilterExtended.isSelected());
}//GEN-LAST:event_jTextFieldIDFromFocusLost

    private void jTextFieldIDFromKeyTyped(java.awt.event.KeyEvent evt)//GEN-FIRST:event_jTextFieldIDFromKeyTyped
    {//GEN-HEADEREND:event_jTextFieldIDFromKeyTyped
        char chCheck;

        // We convert the Character to its Upper case equivalent
        chCheck = Character.toUpperCase(evt.getKeyChar());

        // The Key is the Delete (Backspace) Key
        if (chCheck == 8)
        {
            return;
        }
        // The Key is a number between 0-9
        if ((chCheck > 47) && (chCheck < 58))
        {
            return;
        }
        // The Key is a character between A-F
        if ((chCheck > 64) && (chCheck < 71))
        {
            return;
        }
        // Is neither a number nor a character between A(a) and F(f)
        evt.consume();
}//GEN-LAST:event_jTextFieldIDFromKeyTyped

    private void jTextFieldIDToFocusLost(java.awt.event.FocusEvent evt)//GEN-FIRST:event_jTextFieldIDToFocusLost
    {//GEN-HEADEREND:event_jTextFieldIDToFocusLost
        checkMessageID((JTextField) evt.getComponent(), jCheckBoxFilterExtended.isSelected());
}//GEN-LAST:event_jTextFieldIDToFocusLost

    private void jTextFieldIDToKeyTyped(java.awt.event.KeyEvent evt)//GEN-FIRST:event_jTextFieldIDToKeyTyped
    {//GEN-HEADEREND:event_jTextFieldIDToKeyTyped
        checkHex(evt);
}//GEN-LAST:event_jTextFieldIDToKeyTyped

    private void jButtonFilterSetActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jButtonFilterSetActionPerformed
    {//GEN-HEADEREND:event_jButtonFilterSetActionPerformed
        MutableInteger intBuffer = new MutableInteger(0);
        TPCANStatus status;

        // Gets the current status of the message filter
        if (!GetFilterStatus(intBuffer))
        {
            return;
        }
        // Configures the message filter for a custom range of messages
        if (jRadioFilterCustom.isSelected())
        {
            // The filter must be first closed in order to customize it
            if (intBuffer.value != TPCANParameterValue.PCAN_FILTER_OPEN.getValue())
            {
                // Sets the custom filter
                status = pcanBasic.FilterMessages(getSelectedConnectedChannel(),
                        (int) Long.parseLong(jTextFieldIDFrom.getText(), 16),
                        (int) Long.parseLong(jTextFieldIDTo.getText(), 16),
                        jCheckBoxFilterExtended.isSelected() ? TPCANMode.PCAN_MODE_EXTENDED : TPCANMode.PCAN_MODE_STANDARD);
                // If success, an information message is written, if it is not, an error message is shown
                if (status == TPCANStatus.PCAN_ERROR_OK)
                {
                    showInfo("The filter was customized. IDs from " + jTextFieldIDFrom.getText() + " to " + jTextFieldIDTo.getText(), false);
                }
                else
                {
                    getError(status);
                }
            }
            else
            {
                showInfo("The filter must be closed first in order to be able to customize it", true);
            }
            return;
        }
        // The filter will be full opened or complete closed
        if (jRadioFilterClose.isSelected())
        {
            intBuffer = new MutableInteger(TPCANParameterValue.PCAN_FILTER_CLOSE.getValue());
        }
        else
        {
            intBuffer = new MutableInteger(TPCANParameterValue.PCAN_FILTER_OPEN.getValue());
        }
        // The filter is configured
        status = pcanBasic.SetValue(getSelectedConnectedChannel(),TPCANParameter.PCAN_MESSAGE_FILTER,intBuffer,Integer.SIZE);

        // If success, an information message is written, if it is not, an error message is shown
        if (status == TPCANStatus.PCAN_ERROR_OK)
        {
            if (jRadioFilterClose.isSelected())
            {
                showInfo("The filter was successfully closed", false);
            }
            else
            {
                showInfo("The filter was successfully opened", false);
            }
        }
        else
        {
            getError(status);
        }
}//GEN-LAST:event_jButtonFilterSetActionPerformed

    private void jCheckBoxFilterExtendedActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jCheckBoxFilterExtendedActionPerformed
    {//GEN-HEADEREND:event_jCheckBoxFilterExtendedActionPerformed
        checkMessageID(jTextFieldIDFrom, jCheckBoxFilterExtended.isSelected());
        checkMessageID(jTextFieldIDTo, jCheckBoxFilterExtended.isSelected());
    }//GEN-LAST:event_jCheckBoxFilterExtendedActionPerformed

    private void jButtonFilterQueryActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jButtonFilterQueryActionPerformed
    {//GEN-HEADEREND:event_jButtonFilterQueryActionPerformed
        MutableInteger integerBuffer = new MutableInteger(0);

        // Queries the current status of the message filter
        if (GetFilterStatus(integerBuffer))
        {
            switch (TPCANParameterValue.parseFilterStatus(integerBuffer.value))
            {
                // The filter is closed
                case PCAN_FILTER_CLOSE:
                    showInfo("The Status of the filter is: closed.", false);
                    break;
                // The filter is fully opened
                case PCAN_FILTER_OPEN:
                    showInfo("The Status of the filter is: full opened.", false);
                    break;
                // The filter is customized
                case PCAN_FILTER_CUSTOM:
                    showInfo("The Status of the filter is: customized.", false);
                    break;
                // The status of the filter is undefined. (Should never happen)
                default:
                    showInfo("The Status of the filter is: Invalid.", false);
                    break;
            }
        }
    }//GEN-LAST:event_jButtonFilterQueryActionPerformed

    private void jButtonCloseActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jButtonCloseActionPerformed
    {//GEN-HEADEREND:event_jButtonCloseActionPerformed
        TPCANStatus status;

        // Stop Timer Thread
        if ((canReadThread != null) && (!canReadThread.isInterrupted()))
        {
            canReadThread.interrupt();
            try
            {
                canReadThread.join();
            }
            catch (InterruptedException ex)
            {
            }
        }
            
        // Stop Timer Send Thread
        if ((canSendThread != null) && (!canSendThread.isInterrupted()))
        {
            canSendThread.interrupt();
            try
            {
                canSendThread.join();
            }
            catch (InterruptedException ex)
            {
                
            }
        }        

        // Unitializes each connected Channel
        for (ChannelItem subItem : connectedChannelCollection)
        {
            if (subItem != MarkAllChannelItem.getInstance())
            {
                status = uninitialize(subItem);
                if (status != TPCANStatus.PCAN_ERROR_OK){
                    return;}
            }
        }

        // Exit the application
        System.exit(0);
    }//GEN-LAST:event_jButtonCloseActionPerformed

    private void formWindowClosing(java.awt.event.WindowEvent evt)//GEN-FIRST:event_formWindowClosing
    {//GEN-HEADEREND:event_formWindowClosing
        //Close App
        jButtonCloseActionPerformed(null);
    }//GEN-LAST:event_formWindowClosing

    private void jCheckBoxSendingThreadActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxSendingThreadActionPerformed

        if(jCheckBoxSendingThread.isSelected())
        {
            changeSendMode(true);
        }else
        {
            //send message only when "WriteMessage" pressed
            changeSendMode(false);
        }
        
    }//GEN-LAST:event_jCheckBoxSendingThreadActionPerformed

    private void jCheckBoxSingleActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxSingleActionPerformed
        // TODO add your handling code here:
        if(jCheckBoxSingle.isSelected())
        {
            jCheckBoxSegmented.setSelected(false);
        }else
        {
            jCheckBoxSegmented.setSelected(true);
        }
    }//GEN-LAST:event_jCheckBoxSingleActionPerformed

    private void jCheckBoxSegmentedActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxSegmentedActionPerformed
        // TODO add your handling code here:
        if(jCheckBoxSegmented.isSelected())
        {
            jCheckBoxSingle.setSelected(false);
        }else
        {
            jCheckBoxSingle.setSelected(true);
        }
    }//GEN-LAST:event_jCheckBoxSegmentedActionPerformed

    private void jButtonConnectActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonConnectActionPerformed
        TPCANStatus res;
        ChannelItem item;
        TPCANBaudrate rate1, rate2;

        // only for a sample - we set the userbaudrate0 to 0x001C
        rate1 = TPCANBaudrate.PCAN_BAUD_User0;  // user0 .. 9
        rate1.clearValue();
        rate1.setValue(0x001C);

        // only for a sample - we set the userbaudrate1 to 0x472F
        rate2 = TPCANBaudrate.PCAN_BAUD_User1;  // user0 .. 9
        rate2.clearValue();
        rate2.setValue(0x472F);

        if (isSelectedCanFd())
        {
            res = pcanBasic.InitializeFD(getSelectedChannel(), getSelectedBitRateFd());
        }
        else
        {
            // According to the active parameters/hardware, we
            // use one of the two possible "Init" PCANLight functions.
            // One is for Plug-and-Play hardware, and the other for
            // Non-P&P.
            if (jComboBoxPort.isEnabled())
            {
                // Non-P&P Hardware
                res = pcanBasic.Initialize(getSelectedChannel(), getSelectedBaudrate(), getSelectedHardwareType(), getSelectedPort(), getSelectedInterrupt());
            }
            else
            {
                // P&P Hardware
                res = pcanBasic.Initialize(getSelectedChannel(), getSelectedBaudrate(), TPCANType.PCAN_TYPE_NONE, 0, (short) 0);
            }
        }
        // The Hardware was successfully initiated
        if (res == TPCANStatus.PCAN_ERROR_OK)
        {
            if (jComboBoxPort.isEnabled())
            {
                // Non-P&P Hardware
                item = new ChannelItem(getSelectedChannel(), getSelectedHardwareType(), jCheckBoxCanFd.isSelected());
            }
            else
            {
                // P&P Hardware
                item = new ChannelItem(getSelectedChannel(), jCheckBoxCanFd.isSelected());
            }
            connectedChannelCollection.add(item);
            if ((connectedChannelCollection.size() > 1) && (!connectedChannelCollection.contains(MarkAllChannelItem.getInstance())))
            {
                connectedChannelCollection.add(MarkAllChannelItem.getInstance());
            }
            jComboBoxConnectedChannel.setSelectedItem(item);
            showInfo(item.getHandle().toString() + " Successfully initialized", false);
        }
        else
        {
            getError(res);
        }
    }//GEN-LAST:event_jButtonConnectActionPerformed

    private void jComboBoxBaudrateActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxBaudrateActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_jComboBoxBaudrateActionPerformed

    private void jComboBoxChannelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxChannelActionPerformed
        boolean isNonPnP = false;

        // Check selected Channel is a NON-PNP device
        switch ((TPCANHandle) jComboBoxChannel.getSelectedItem())
        {
            case PCAN_DNGBUS1:
            case PCAN_ISABUS1:
            case PCAN_ISABUS2:
            case PCAN_ISABUS3:
            case PCAN_ISABUS4:
            case PCAN_ISABUS5:
            case PCAN_ISABUS6:
            case PCAN_ISABUS7:
            case PCAN_ISABUS8:
            isNonPnP = true;
            break;
        }

        // Update UI depending NON-PNP device
        jComboBoxHardwareType.setEnabled(isNonPnP);
        jComboBoxPort.setEnabled(isNonPnP);
        jComboBoxInterrupt.setEnabled(isNonPnP);
    }//GEN-LAST:event_jComboBoxChannelActionPerformed

    private void jCheckBoxCanFdActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxCanFdActionPerformed
        boolean isCanFd = isSelectedCanFd();
        jComboBoxBaudrate.setEnabled(!isCanFd);
        jComboBoxHardwareType.setEnabled(!isCanFd);
        jComboBoxPort.setEnabled(!isCanFd);
        jComboBoxInterrupt.setEnabled(!isCanFd);        
        jTextAreaBitRateFd.setEnabled(isCanFd);
    }//GEN-LAST:event_jCheckBoxCanFdActionPerformed

    private void jButtonReadClearActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonReadClearActionPerformed
        synchronized(Application.token) {
            receivedData.clear();
            ((DefaultTableModel)jTableMessage.getModel()).setRowCount(0);
        }
        
    }//GEN-LAST:event_jButtonReadClearActionPerformed

    private void jTextFieldWriteID1FocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_jTextFieldWriteID1FocusLost
        // TODO add your handling code here:
    }//GEN-LAST:event_jTextFieldWriteID1FocusLost

    private void jTextFieldWriteID1KeyTyped(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_jTextFieldWriteID1KeyTyped
        // TODO add your handling code here:
    }//GEN-LAST:event_jTextFieldWriteID1KeyTyped

    private void jCheckBoxWriteFdActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxWriteFdActionPerformed
            jCheckBoxWriteBrs.setEnabled(jCheckBoxWriteFd.isSelected());
            jCheckBoxWriteRemote.setEnabled(!jCheckBoxWriteFd.isSelected());
            if (jCheckBoxWriteFd.isEnabled() && jCheckBoxWriteFd.isSelected())
                ((SpinnerNumberModel) jSpinnerLength.getModel()).setMaximum(15); 
            else {
                ((SpinnerNumberModel) jSpinnerLength.getModel()).setMaximum(8); 
                if ((Integer)jSpinnerLength.getValue() > 8)
                    jSpinnerLength.setValue(8);
            }
    }//GEN-LAST:event_jCheckBoxWriteFdActionPerformed

    private void jCheckBoxWriteBrsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxWriteBrsActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_jCheckBoxWriteBrsActionPerformed

    private void jButtonBrowseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonBrowseActionPerformed
        // Shows File Chooser in order to selecte log file path - Browse
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        // If user clicks "Select", gets selected file path
        if (JFileChooser.APPROVE_OPTION == chooser.showDialog(null, "Select"))
        {
            jTextAreaPath.setText(chooser.getSelectedFile().toString());
            if (jTextAreaPath.getText().length() > 0){
                jButtonSet.setEnabled(true);}
        }
    }//GEN-LAST:event_jButtonBrowseActionPerformed

    private void jTextFieldDataFocusGained(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_jTextFieldDataFocusGained
        if (evt.getComponent() instanceof JTextField)
        {
            ((JTextField) evt.getComponent()).setSelectionStart(0);
            ((JTextField) evt.getComponent()).setSelectionEnd(2);
        }
    }//GEN-LAST:event_jTextFieldDataFocusGained

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroupFilter;
    private javax.swing.ButtonGroup buttonGroupONOFF;
    private javax.swing.ButtonGroup buttonGroupOpenClose;
    private javax.swing.ButtonGroup buttonGroupReadMode;
    private javax.swing.JButton jButtonBrowse;
    private javax.swing.JButton jButtonClose;
    private javax.swing.JButton jButtonConnect;
    private javax.swing.JButton jButtonFilterQuery;
    private javax.swing.JButton jButtonFilterSet;
    private javax.swing.JButton jButtonGet;
    private javax.swing.JButton jButtonPause;
    private javax.swing.JButton jButtonReadClear;
    private javax.swing.JButton jButtonRelease;
    private javax.swing.JButton jButtonSet;
    private javax.swing.JButton jButtonStart;
    private javax.swing.JButton jButtonWrite;
    private javax.swing.JCheckBox jCheckBoxCanFd;
    private javax.swing.JCheckBox jCheckBoxDate;
    private javax.swing.JCheckBox jCheckBoxEntry;
    private javax.swing.JCheckBox jCheckBoxFilterExtended;
    private javax.swing.JCheckBox jCheckBoxLeave;
    private javax.swing.JCheckBox jCheckBoxOverwrite;
    private javax.swing.JCheckBox jCheckBoxParameter;
    private javax.swing.JCheckBox jCheckBoxRead;
    private javax.swing.JCheckBox jCheckBoxSegmented;
    private javax.swing.JCheckBox jCheckBoxSendingThread;
    private javax.swing.JCheckBox jCheckBoxSingle;
    private javax.swing.JCheckBox jCheckBoxTime;
    private javax.swing.JCheckBox jCheckBoxTimeStamp;
    private javax.swing.JCheckBox jCheckBoxWrite;
    private javax.swing.JCheckBox jCheckBoxWriteBrs;
    private javax.swing.JCheckBox jCheckBoxWriteExtended;
    private javax.swing.JCheckBox jCheckBoxWriteFd;
    private javax.swing.JCheckBox jCheckBoxWriteRemote;
    private javax.swing.JComboBox jComboBoxBaudrate;
    private javax.swing.JComboBox jComboBoxChannel;
    private javax.swing.JComboBox jComboBoxConnectedChannel;
    private javax.swing.JComboBox jComboBoxHardwareType;
    private javax.swing.JComboBox jComboBoxInterrupt;
    private javax.swing.JComboBox jComboBoxParameter;
    private javax.swing.JComboBox jComboBoxPort;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel12;
    private javax.swing.JLabel jLabel13;
    private javax.swing.JLabel jLabel14;
    private javax.swing.JLabel jLabel15;
    private javax.swing.JLabel jLabel16;
    private javax.swing.JLabel jLabel17;
    private javax.swing.JLabel jLabel18;
    private javax.swing.JLabel jLabel19;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel20;
    private javax.swing.JLabel jLabel21;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel61;
    private javax.swing.JLabel jLabel62;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLayeredPane jLayeredPaneConfiguration;
    private javax.swing.JPanel jPanelActivation;
    private javax.swing.JPanel jPanelConfiguration;
    private javax.swing.JPanel jPanelDeviceNumber;
    private javax.swing.JPanel jPanelFilter;
    private javax.swing.JPanel jPanelHardware;
    private javax.swing.JPanel jPanelInfo;
    private javax.swing.JPanel jPanelLogConfigure;
    private javax.swing.JPanel jPanelLogPath;
    private javax.swing.JPanel jPanelNewConnection;
    private javax.swing.JPanel jPanelRead;
    private javax.swing.JPanel jPanelTraceConfigure;
    private javax.swing.JPanel jPanelTraceSize;
    private javax.swing.JPanel jPanelWrite;
    private javax.swing.JPanel jPanelWriteData;
    private javax.swing.JRadioButton jRadioButtonEvent;
    private javax.swing.JRadioButton jRadioButtonOFF;
    private javax.swing.JRadioButton jRadioButtonON;
    private javax.swing.JRadioButton jRadioButtonTimer;
    private javax.swing.JRadioButton jRadioFilterClose;
    private javax.swing.JRadioButton jRadioFilterCustom;
    private javax.swing.JRadioButton jRadioFilterOpen;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JScrollPane jScrollPaneInfo;
    private javax.swing.JScrollPane jScrollPaneParameterDescription;
    private javax.swing.JScrollPane jScrollPanePath;
    private javax.swing.JSpinner jSpinnerDeviceNumber;
    private javax.swing.JSpinner jSpinnerLength;
    private javax.swing.JSpinner jSpinnerTraceSize;
    private javax.swing.JTable jTableMessage;
    private javax.swing.JTextArea jTextAreaBitRateFd;
    private javax.swing.JTextArea jTextAreaParameterDescription;
    private javax.swing.JTextArea jTextAreaPath;
    private javax.swing.JTextField jTextFieldData0;
    private javax.swing.JTextField jTextFieldData1;
    private javax.swing.JTextField jTextFieldData10;
    private javax.swing.JTextField jTextFieldData11;
    private javax.swing.JTextField jTextFieldData12;
    private javax.swing.JTextField jTextFieldData13;
    private javax.swing.JTextField jTextFieldData14;
    private javax.swing.JTextField jTextFieldData15;
    private javax.swing.JTextField jTextFieldData16;
    private javax.swing.JTextField jTextFieldData17;
    private javax.swing.JTextField jTextFieldData18;
    private javax.swing.JTextField jTextFieldData19;
    private javax.swing.JTextField jTextFieldData2;
    private javax.swing.JTextField jTextFieldData20;
    private javax.swing.JTextField jTextFieldData21;
    private javax.swing.JTextField jTextFieldData22;
    private javax.swing.JTextField jTextFieldData23;
    private javax.swing.JTextField jTextFieldData24;
    private javax.swing.JTextField jTextFieldData25;
    private javax.swing.JTextField jTextFieldData26;
    private javax.swing.JTextField jTextFieldData27;
    private javax.swing.JTextField jTextFieldData28;
    private javax.swing.JTextField jTextFieldData29;
    private javax.swing.JTextField jTextFieldData3;
    private javax.swing.JTextField jTextFieldData30;
    private javax.swing.JTextField jTextFieldData31;
    private javax.swing.JTextField jTextFieldData32;
    private javax.swing.JTextField jTextFieldData33;
    private javax.swing.JTextField jTextFieldData34;
    private javax.swing.JTextField jTextFieldData35;
    private javax.swing.JTextField jTextFieldData36;
    private javax.swing.JTextField jTextFieldData37;
    private javax.swing.JTextField jTextFieldData38;
    private javax.swing.JTextField jTextFieldData39;
    private javax.swing.JTextField jTextFieldData4;
    private javax.swing.JTextField jTextFieldData40;
    private javax.swing.JTextField jTextFieldData41;
    private javax.swing.JTextField jTextFieldData42;
    private javax.swing.JTextField jTextFieldData43;
    private javax.swing.JTextField jTextFieldData44;
    private javax.swing.JTextField jTextFieldData45;
    private javax.swing.JTextField jTextFieldData46;
    private javax.swing.JTextField jTextFieldData47;
    private javax.swing.JTextField jTextFieldData48;
    private javax.swing.JTextField jTextFieldData49;
    private javax.swing.JTextField jTextFieldData5;
    private javax.swing.JTextField jTextFieldData50;
    private javax.swing.JTextField jTextFieldData51;
    private javax.swing.JTextField jTextFieldData52;
    private javax.swing.JTextField jTextFieldData53;
    private javax.swing.JTextField jTextFieldData54;
    private javax.swing.JTextField jTextFieldData55;
    private javax.swing.JTextField jTextFieldData56;
    private javax.swing.JTextField jTextFieldData57;
    private javax.swing.JTextField jTextFieldData58;
    private javax.swing.JTextField jTextFieldData59;
    private javax.swing.JTextField jTextFieldData6;
    private javax.swing.JTextField jTextFieldData60;
    private javax.swing.JTextField jTextFieldData61;
    private javax.swing.JTextField jTextFieldData62;
    private javax.swing.JTextField jTextFieldData63;
    private javax.swing.JTextField jTextFieldData7;
    private javax.swing.JTextField jTextFieldData8;
    private javax.swing.JTextField jTextFieldData9;
    private javax.swing.JTextField jTextFieldIDFrom;
    private javax.swing.JTextField jTextFieldIDTo;
    private javax.swing.JTextField jTextFieldSendTiming;
    private javax.swing.JTextField jTextFieldWriteID;
    private javax.swing.JTextField jTextFieldWriteID1;
    private javax.swing.JTextArea jTexteAreaInfo;
    // End of variables declaration//GEN-END:variables
    // Static Token For Synchronization
    static public final Object token = new Object();
    // PCANBasic instance
    PCANBasic pcanBasic = null;
    // Collection containing connected channels
    Vector<ChannelItem> connectedChannelCollection = null;
    // Configured language
    short languageIndex = 0;
    // Thread to read CAN messages
    CANReadThread canReadThread;
    // Thread to send CAN messages
    CANSendThread canSendThread;    
    // Thread to refresh data grid
    TableMessageThread tableMessageThread;
    // Map to store received messages
    private HashMap receivedData = new HashMap();
    // Grid column to show TimeStamp
    private TableColumn columnTimeStamp = null;

    // Returns selected TPCANBaudrate
    private TPCANBaudrate getSelectedBaudrate()
    {
        return (TPCANBaudrate) jComboBoxBaudrate.getSelectedItem();
    }
        
    // Returns selected TPCANBitRateFd
    private TPCANBitrateFD getSelectedBitRateFd()
    {
        return new TPCANBitrateFD(jTextAreaBitRateFd.getText());
    }
    // Defines if CAN-FD support is set
    private boolean isSelectedCanFd()
    {
        return jCheckBoxCanFd.isSelected();
    }

    // Returns selected non-connected TPCANHandle
    private TPCANHandle getSelectedChannel()
    {
        return (TPCANHandle) jComboBoxChannel.getSelectedItem();
    }

    // Returns selected TPCANType
    private TPCANType getSelectedHardwareType()
    {
        return (TPCANType) jComboBoxHardwareType.getSelectedItem();
    }

    // Returns selected port number
    private int getSelectedPort()
    {
        return new Integer(jComboBoxPort.getSelectedItem().toString());
    }

    // Returns selected connected TPCANHandle
    private TPCANHandle getSelectedConnectedChannel()
    {
        if (jComboBoxConnectedChannel.getSelectedIndex() != -1)
        {
            return ((ChannelItem) (jComboBoxConnectedChannel.getSelectedItem())).getHandle();
        }
        else
        {
            return TPCANHandle.PCAN_NONEBUS;
        }
    }

    // Returns selected ChannelItem
    private ChannelItem getSelectedChannelItem()
    {
        if (jComboBoxConnectedChannel.getSelectedIndex() != -1)
        {
            return (ChannelItem) (jComboBoxConnectedChannel.getSelectedItem());
        }
        else
        {
            return null;
        }
    }

    // Returns selected interrupt value
    private short getSelectedInterrupt()
    {
        return new Short(jComboBoxInterrupt.getSelectedItem().toString());
    }

    // Returns selected activation value(ON||OFF)
    private TPCANParameterValue getSelectedActivationValue()
    {
        if (jRadioButtonON.isSelected())
        {
            return TPCANParameterValue.PCAN_PARAMETER_ON;
        }
        else
        {
            return TPCANParameterValue.PCAN_PARAMETER_OFF;
        }
    }

    // Process and Displays PCANBasic Error Message
    private void getError(TPCANStatus status)
    {
        StringBuffer error;

        // If Error
        if (status != TPCANStatus.PCAN_ERROR_OK)
        {
            error = new StringBuffer("");
            status = pcanBasic.GetErrorText(status, languageIndex, error);
            // Display Error
            if (status == TPCANStatus.PCAN_ERROR_OK)
            {
                showInfo(error.toString(), true);
            }
            // Unable To Retrieve Error
            else
            {
                showInfo("Unable to call GetErrorText Function !", true);
            }
            error = null;
        }
    }

    // Displays Info Message
    private void showInfo(String text, boolean error)
    {
        // If it's an error message, configure foreground in red
        if (error)
        {
            jTexteAreaInfo.setForeground(new java.awt.Color(255, 0, 0));
        }
        // Else configure foreground in black
        else
        {
            jTexteAreaInfo.setForeground(new java.awt.Color(0, 0, 0));
        }
        // Update txtInfo box
        jTexteAreaInfo.setText(text);
    }

    // Changes the send method function
    private void changeSendMode(boolean active)
    {
      Integer SendInterval;
      // Stop send Thread if running  
      if((canSendThread != null)  && (!canSendThread.isInterrupted()))
      {
          canSendThread.interrupt();
          try
          {
              canSendThread.join();
          }
          catch(InterruptedException ex)
          {
              
          }
      }
      if(active)
      {
        // Create New CANSendThread with default values
        canSendThread = new CANSendThread(pcanBasic, connectedChannelCollection);
        //send the Message every x ms
        SendInterval = (int) Long.parseLong(jTextFieldSendTiming.getText(), 10);
        if(SendInterval<0 || SendInterval> SendInterval.MAX_VALUE)
        {
            SendInterval=100;
        }
        canSendThread.setSendInterval(SendInterval);
        // Start Timer Thread to send CAN Messages
        canSendThread.start();   
      }
      SendInterval=null; 
    }
    
    // Changes the read method function
    private void changeReadMode(boolean useTimerMode)
    {
        TPCANStatus status;
        StringBuffer error;

        // Stop Timer Thread
        if ((canReadThread != null) && (!canReadThread.isInterrupted()))
        {
            canReadThread.interrupt();
            try
            {
                canReadThread.join();
            }
            catch (InterruptedException ex)
            {
            }
            canReadThread=null;
        }

        // Create New CANReadThread with default values
        canReadThread = new CANReadThread(pcanBasic, connectedChannelCollection, receivedData);
        canReadThread.setReadTimeStamp(jCheckBoxTimeStamp.isSelected());
        if (useTimerMode)
        {
            // Iterate All Connected Channels
            for (ChannelItem channel : connectedChannelCollection)
            {
                // If isWorking, call SetRcvEvent on current channel
                if (channel.getWorking())
                {
                    status = pcanBasic.ResetRcvEvent(channel.getHandle());
                    if (status != TPCANStatus.PCAN_ERROR_OK)
                    {
                        getError(status);
                    }
                }
            }

            // Start Timer Thread to read CAN Messages
            canReadThread.start();
        }
        else
        {
            // Set canReadThread as RcvEvent Listener
            RcvEventDispatcher.setListener(canReadThread);

            // Iterate All Connected Channels
            for (ChannelItem channel : connectedChannelCollection)
            {
                // If isWorking, call SetRcvEvent on current channel
                if (channel.getWorking())
                {
                    status = pcanBasic.SetRcvEvent(channel.getHandle());
                    if (status != TPCANStatus.PCAN_ERROR_OK)
                    {
                        getError(status);
                    }
                }
            }
        }
    }

    // Changes Channel state in order to pass from pause to working and inverssely
    private void changeChannelState(ChannelItem item, boolean workingState)
    {
        TPCANStatus status;
        StringBuffer error;

        // Configure ChannelItem
        item.setWorking(workingState);

        // If Read By Event Is Selected
        if (jRadioButtonEvent.isSelected())
        {
            // Call SetRcvEvent Function
            if (workingState)
            {
                status = pcanBasic.SetRcvEvent(item.getHandle());
            }
            else
            {
                status = pcanBasic.ResetRcvEvent(item.getHandle());
            }
            // If Error
            if (status != TPCANStatus.PCAN_ERROR_OK)
            {
                getError(status);
            }
        }
    }

    // Enables/disables UI depending of connected channel(s) in order to block or active Application features
    private void UpdateUIButtons()
    {
        // By default, disable main features(Write and Filter)
        jButtonWrite.setEnabled(false);
        jButtonFilterSet.setEnabled(false);
        jButtonFilterQuery.setEnabled(false);
        jCheckBoxSendingThread.setEnabled(false);
        jTextFieldSendTiming.setEnabled(false);
                
        jCheckBoxWriteFd.setEnabled(false);
        jCheckBoxWriteBrs.setEnabled(false);
        jCheckBoxWriteFd.setVisible(false);
        jCheckBoxWriteBrs.setVisible(false);        
        jCheckBoxWriteRemote.setEnabled(true);
        ((SpinnerNumberModel) jSpinnerLength.getModel()).setMaximum(8);

        // If any channel is connected
        if (connectedChannelCollection.size() > 0)
        {
            // Enables Release button
            jButtonRelease.setEnabled(true);

            // Gets selected and connected ChannelItem
            ChannelItem item = (ChannelItem) jComboBoxConnectedChannel.getModel().getSelectedItem();

            // If it is a simple ChannelItem
            if (item != MarkAllChannelItem.getInstance())
            {
                jButtonPause.setEnabled(item.getWorking());
                jButtonStart.setEnabled(!item.getWorking());
                jButtonWrite.setEnabled(true);
                jButtonFilterSet.setEnabled(true);
                jButtonFilterQuery.setEnabled(true);
                jCheckBoxSendingThread.setEnabled(true);
                jTextFieldSendTiming.setEnabled(true);
                
                if (item.isCanFd()) {
                    jCheckBoxWriteFd.setEnabled(!jCheckBoxWriteRemote.isSelected());
                    jCheckBoxWriteBrs.setEnabled(jCheckBoxWriteFd.isSelected());
                    jCheckBoxWriteFd.setVisible(true);
                    jCheckBoxWriteBrs.setVisible(true);     
                    if (jCheckBoxWriteFd.isEnabled() && jCheckBoxWriteFd.isSelected())
                        ((SpinnerNumberModel) jSpinnerLength.getModel()).setMaximum(15);               
                }                   
                jCheckBoxWriteRemote.setEnabled(!jCheckBoxWriteFd.isVisible() ||
                        !jCheckBoxWriteFd.isEnabled() || !jCheckBoxWriteFd.isSelected());
            }
            // Else it is the MarkAllChannelItem
            else
            {
                boolean containsWorkingChannels = false;
                boolean containsStoppedChannels = false;
                for (ChannelItem channel : connectedChannelCollection)
                {
                    if (channel == MarkAllChannelItem.getInstance())
                    {
                        continue;
                    }
                    if (channel.getWorking())
                    {
                        containsWorkingChannels = true;
                    }
                    else
                    {
                        containsStoppedChannels = true;
                    }
                }
                jButtonPause.setEnabled(containsWorkingChannels);
                jButtonStart.setEnabled(containsStoppedChannels);
            }
        }
        // No channel connected
        else
        {
            jButtonStart.setEnabled(false);
            jButtonPause.setEnabled(false);
            jButtonRelease.setEnabled(false);
        }

        if ( ((Integer)jSpinnerLength.getValue()) > ((Integer) ((SpinnerNumberModel) jSpinnerLength.getModel()).getMaximum()))
            jSpinnerLength.setValue(((SpinnerNumberModel) jSpinnerLength.getModel()).getMaximum());
        jSpinnerLengthStateChanged(null);
        // Update Parameter Panel
        jComboBoxParameterActionPerformed(null);
    }

    // Unitializes Channel using ChannelItem
    private TPCANStatus uninitialize(ChannelItem item)
    {
        TPCANStatus status;
        // Sets Channel in pause if need be
        if (item.getWorking())
        {
            changeChannelState(item, false);
        }
        // Releases the connected PCAN-Basic channel
        status = pcanBasic.Uninitialize(item.getHandle());

        // Process Result
        if (status != TPCANStatus.PCAN_ERROR_OK)
        {
            getError(status);
        }
        return status;
    }

    // Checks typed key is an hexadecimal character
    private void checkHex(java.awt.event.KeyEvent evt)
    {
        char chCheck;

        // We convert the Character to its Upper case equivalent
        chCheck = Character.toUpperCase(evt.getKeyChar());

        // The Key is the Delete (Backspace) Key
        if (chCheck == 8)
        {
            return;
        }
        // The Key is a number between 0-9
        if ((chCheck > 47) && (chCheck < 58))
        {
            return;
        }
        // The Key is a character between A-F
        if ((chCheck > 64) && (chCheck < 71))
        {
            return;
        }
        // Is neither a number nor a character between A(a) and F(f)
        evt.consume();
    }

    // Checks current Data Box contains valid values
    private void checkDataBox(JTextField IdBox)
    {
        int MaxValue;

        // Set To Upper Case
        IdBox.setText(IdBox.getText().toUpperCase());

        // We verify number of characters
        if (IdBox.getText().length() > 2)
        {
            IdBox.setText(IdBox.getText().substring(0, 2));
        }
        // calculate the text length and Maximum ID value according
        // with the Message Type
        MaxValue = (int) 0x7FF;

        // The Textbox for the ID is represented with 3 characters for
        // Standard and 8 characters for extended messages.
        // Therefore if the Length of the text is smaller than TextLength,
        // we add "0"
        while (IdBox.getText().length() != 2)
        {
            IdBox.setText("0" + IdBox.getText());
        }

        // Because in this example will be sent only Standard messages
        // we check that the ID is not bigger than 0x7FF
        if (Integer.parseInt(IdBox.getText(), 16) > MaxValue)
        {
            IdBox.setText("7FF");
        }

    }
    // Checks JTextField hexadecimal content

    private void checkMessageID(JTextField IdBox, boolean isExtended)
    {
        int TextLength;
        int MaxValue;
        int maxLength = 3;

        // Set To Upper Case
        IdBox.setText(IdBox.getText().toUpperCase());

        // We verify number of characters
        if (isExtended)
        {
            maxLength = 8;
        }
        if (IdBox.getText().length() > maxLength)
        {
            IdBox.setText(IdBox.getText().substring(0, maxLength));
        }
        // calculate the text length and Maximum ID value according
        // with the Message Type
        TextLength = (isExtended) ? 8 : 3;
        MaxValue = (isExtended) ? (int) 0x1FFFFFFF : (int) 0x7FF;

        // The Textbox for the ID is represented with 3 characters for
        // Standard and 8 characters for extended messages.
        // Therefore if the Length of the text is smaller than TextLength,
        // we add "0"
        while (IdBox.getText().length() != TextLength)
        {
            IdBox.setText("0" + IdBox.getText());
        }

        // Because in this example will be sent only Standard messages
        // we check that the ID is not bigger than 0x7FF
        if (Long.parseLong(IdBox.getText(), 16) > MaxValue)
        {
            if (isExtended)
            {
                IdBox.setText("1FFFFFFF");
            }
            else
            {
                IdBox.setText("7FF");
            }
        }
    }

    // Converts a string to hex
    static long hexTextToInt(String toConvert)
    {
        long iToReturn = 0;
        int iExp = 0;
        char chByte;

        // The string to convert is empty
        if (toConvert.equals(""))
        {
            return 0;
        }
        // The string have more than 8 character (the equivalent value
        // exeeds the DWORD capacyty
        if (toConvert.length() > 8)
        {
            return 0;
        }
        // We convert any character to its Upper case
        toConvert = toConvert.toUpperCase();
        try
        {
            // We calculate the number using the Hex To Decimal formula
            for (int i = toConvert.length() - 1; i >= 0; i--)
            {
                chByte = (char) toConvert.getBytes()[i];
                switch ((int) chByte)
                {
                    case 65:
                        iToReturn += (long) (10 * Math.pow(16.0f, iExp));
                        break;
                    case 66:
                        iToReturn += (long) (11 * Math.pow(16.0f, iExp));
                        break;
                    case 67:
                        iToReturn += (long) (12 * Math.pow(16.0f, iExp));
                        break;
                    case 68:
                        iToReturn += (long) (13 * Math.pow(16.0f, iExp));
                        break;
                    case 69:
                        iToReturn += (long) (14 * Math.pow(16.0f, iExp));
                        break;
                    case 70:
                        iToReturn += (long) (15 * Math.pow(16.0f, iExp));
                        break;
                    default:
                        if ((chByte < 48) || (chByte > 57))
                        {
                            return -1;
                        }
                        iToReturn += (long) Integer.parseInt(((Character) chByte).toString()) * Math.pow(16.0f, iExp);
                        break;
                }
                iExp++;
            }
        }
        catch (Exception ex)
        {
            // Error, return 0
            return 0;
        }
        return iToReturn;
    }

    // Gets the current status of the PCAN-Basic message filter
    private boolean GetFilterStatus(MutableInteger filterStatus)
    {
        TPCANStatus status;

        // Tries to get the status of the filter for the current connected hardware
        status = pcanBasic.GetValue(getSelectedConnectedChannel(), TPCANParameter.PCAN_MESSAGE_FILTER, filterStatus, Integer.SIZE);

        // If it fails, a error message is shown
        if (status != TPCANStatus.PCAN_ERROR_OK)
        {
            getError(status);
            return false;
        }
        return true;
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String args[])
    {
        java.awt.EventQueue.invokeLater(new Runnable()
        {
            
            public void run()
            {
                new Application().setVisible(true);
            }
        });
    }

    private TPCANBaudrate TPCANBaudrate(TPCANBaudrate tpcanBaudrate) {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }
}
